/*
 * ActionAnnImpl.java
 *
 * Created on 15 de Julho de 2005, 12:09
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.sourceforge.czt.typecheck.circus.impl;

import net.sourceforge.czt.circustools.ast.ActionAnn;
import net.sourceforge.czt.circustools.ast.ActionSignature;
import net.sourceforge.czt.circustools.visitor.ActionAnnVisitor;
import net.sourceforge.czt.typecheck.z.impl.TermImpl;

/**
 *
 * @author Manuela
 */
public class ActionAnnImpl
  extends TermImpl
  implements ActionAnn
{
  
  protected ActionAnnImpl(ActionAnn actionAnn)
  {
    super(actionAnn);
  }

  public void setActionSignature(ActionSignature signature)
  {
    ActionAnn actionAnn = (ActionAnn) term_;
    actionAnn.setActionSignature(signature);
  }

  public ActionSignature getActionSignature()
  {
    ActionAnn actionAnn = (ActionAnn) term_;
    ActionSignature result = actionAnn.getActionSignature();
    return result;
  }

  public net.sourceforge.czt.base.ast.Term create(Object [] args)
  {
    ActionAnn actionAnn = (ActionAnn) term_.create(args);
    ActionAnn result = new ActionAnnImpl(actionAnn);
    return result;
  }

  /**
   * Accepts a visitor.
   */
  public Object accept(net.sourceforge.czt.util.Visitor v)
  {
    if (v instanceof ActionAnnVisitor) {
      ActionAnnVisitor visitor = (ActionAnnVisitor) v;
      return visitor.visitActionAnn(this);
    }
    return super.accept(v);
  }

  public boolean equals(Object obj)
  {
    if (obj instanceof ActionAnn) {
      ActionAnn actionAnn = (ActionAnn) obj;
      return getActionSignature().equals(actionAnn.getActionSignature());
    }
    return false;
  }

  public int hashCode()
  {
    final int constant = 31;

    int hashCode = super.hashCode();
    hashCode += "ActionAnnImpl".hashCode();
    if (getActionSignature() != null) {
      hashCode += constant * getActionSignature().hashCode();
    }
    return hashCode;
  }
}
