/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.z.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.util.Factory;
import net.sourceforge.czt.z.util.ZString;

public class OperatorName {
    private static Factory factory_ = new Factory();
    private String word_;
    private List strokes_ = null;
    private List list_;

    public OperatorName(String name, List strokes) throws OperatorNameException {
        this.word_ = name;
        this.strokes_ = strokes;
        this.list_ = OperatorName.wordToList(name, strokes);
    }

    public OperatorName(Name name) throws OperatorNameException {
        this(name.getWord(), (List)name.getStroke());
    }

    public OperatorName(List list) throws OperatorNameException {
        String errorMessage = list + " is not an operator name.";
        if (list.size() <= 1) {
            throw new OperatorNameException(errorMessage);
        }
        this.list_ = list;
        Boolean expectArgument = null;
        StringBuffer name = new StringBuffer();
        for (String opPart : list) {
            if (opPart.equals(ZString.ARG) || opPart.equals(ZString.ARG_TOK)) {
                if (Boolean.FALSE.equals(expectArgument)) {
                    throw new OperatorNameException(errorMessage);
                }
                name.append(ZString.ARG_TOK);
                expectArgument = Boolean.FALSE;
                continue;
            }
            if (opPart.equals(",,") || opPart.equals(ZString.LISTARG_TOK)) {
                if (Boolean.FALSE.equals(expectArgument)) {
                    throw new OperatorNameException(errorMessage);
                }
                name.append(ZString.LISTARG_TOK);
                expectArgument = Boolean.FALSE;
                continue;
            }
            if (Boolean.TRUE.equals(expectArgument)) {
                throw new OperatorNameException(errorMessage);
            }
            DeclName declName = factory_.createDeclName(opPart);
            name.append(declName.getWord());
            this.checkStrokes((List)declName.getStroke());
            expectArgument = Boolean.TRUE;
        }
        this.word_ = name.toString();
    }

    public OperatorName(String name, List strokes, Fixity fixity) throws OperatorNameException {
        if (Fixity.INFIX.equals(fixity)) {
            this.word_ = ZString.ARG_TOK + name + ZString.ARG_TOK;
            this.strokes_ = strokes;
            this.list_ = OperatorName.wordToList(this.word_, strokes);
        } else if (Fixity.PREFIX.equals(fixity)) {
            this.word_ = name + ZString.ARG_TOK;
            this.strokes_ = strokes;
            this.list_ = OperatorName.wordToList(this.word_, strokes);
        } else if (Fixity.POSTFIX.equals(fixity)) {
            this.word_ = ZString.ARG_TOK + name;
            this.strokes_ = strokes;
            this.list_ = OperatorName.wordToList(this.word_, strokes);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static List wordToList(String name, List strokeList) throws OperatorNameException {
        String errorMessage = name + " is not an operator name.";
        String strokes = OperatorName.strokeListToString(strokeList);
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(name);
        Boolean expectArgument = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || token.equals("")) continue;
            if (token.equals(ZString.ARG) || token.equals(",,")) {
                if (Boolean.FALSE.equals(expectArgument)) {
                    throw new OperatorNameException(errorMessage);
                }
                result.add(token);
                expectArgument = Boolean.FALSE;
                continue;
            }
            if (Boolean.TRUE.equals(expectArgument)) {
                throw new OperatorNameException(errorMessage);
            }
            result.add(token + strokes);
            expectArgument = Boolean.TRUE;
        }
        if (result.size() <= 1) {
            throw new OperatorNameException(errorMessage);
        }
        return result;
    }

    private static String strokeListToString(List strokes) {
        if (strokes == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Stroke stroke : strokes) {
            result.append(stroke.toString());
        }
        return result.toString();
    }

    private void checkStrokes(List strokes) throws OperatorNameException {
        if (this.strokes_ == null) {
            this.strokes_ = strokes;
        } else if (!((Object)this.strokes_).equals(strokes)) {
            String message = "The component names of an operator must have the same decorations.";
            throw new OperatorNameException("The component names of an operator must have the same decorations.");
        }
    }

    public String getWord() {
        return this.word_;
    }

    public List getStroke() {
        return this.strokes_;
    }

    public Iterator iterator() {
        return this.list_.iterator();
    }

    public boolean isUnary() {
        String ARG = ZString.ARG;
        String LISTARG = ",,";
        String first = (String)this.list_.get(0);
        boolean sizeIsTwo = this.list_.size() == 2;
        boolean sizeIsThree = this.list_.size() == 3;
        boolean firstIsArg = first.equals(ARG) || first.equals(",,");
        return sizeIsTwo || sizeIsThree && !firstIsArg;
    }

    public Fixity getFixity() {
        boolean lastIsArg;
        if (this.list_.size() < 2) {
            String message = "A list of size smaller than two cannot occur in operator names.";
            throw new CztException("A list of size smaller than two cannot occur in operator names.");
        }
        String ARG = ZString.ARG;
        String LISTARG = ",,";
        String first = (String)this.list_.get(0);
        String last = (String)this.list_.get(this.list_.size() - 1);
        boolean firstIsArg = first.equals(ARG) || first.equals(",,");
        boolean bl = lastIsArg = last.equals(ARG) || last.equals(",,");
        if (firstIsArg) {
            if (lastIsArg) {
                return Fixity.INFIX;
            }
            return Fixity.POSTFIX;
        }
        if (lastIsArg) {
            return Fixity.PREFIX;
        }
        return Fixity.NOFIX;
    }

    public String toString() {
        return this.getWord();
    }

    public static final class Fixity {
        public static final Fixity PREFIX = new Fixity("PREFIX");
        public static final Fixity POSTFIX = new Fixity("POSTFIX");
        public static final Fixity INFIX = new Fixity("INFIX");
        public static final Fixity NOFIX = new Fixity("NOFIX");
        private final String name_;

        private Fixity(String name) {
            this.name_ = name;
        }

        public String toString() {
            return this.name_;
        }

        public static Fixity fromString(String value) {
            if (value.equals("PREFIX")) {
                return PREFIX;
            }
            if (value.equals("POSTFIX")) {
                return POSTFIX;
            }
            if (value.equals("INFIX")) {
                return INFIX;
            }
            if (value.equals("NOFIX")) {
                return NOFIX;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class OperatorNameException
    extends Exception {
        public OperatorNameException() {
        }

        public OperatorNameException(String message) {
            super(message);
        }

        public OperatorNameException(String message, Throwable cause) {
            super(message, cause);
        }

        public OperatorNameException(Throwable cause) {
            super(cause);
        }
    }
}

