/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;

public final class DebugProxy
implements InvocationHandler {
    private Object object_;

    private DebugProxy(Object object) {
        this.getLogger().fine("Create new DebugProxy for " + object);
        this.object_ = object;
    }

    private Logger getLogger() {
        return Logger.getLogger("debug");
    }

    public static Object newInstance(Object object) {
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)new DebugProxy(object));
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        if (args != null) {
            this.getLogger().entering(this.object_.getClass().toString(), m.getName(), args);
        } else {
            this.getLogger().entering(this.object_.getClass().toString(), m.getName());
        }
        try {
            result = m.invoke(this.object_, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.getLogger().fine("Caught exception " + e);
            throw e;
        }
        finally {
            this.getLogger().exiting(this.object_.getClass().toString(), m.getName(), result);
        }
        return result;
    }
}

