/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.java_cup.runtime.lr_parser;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.parser.util.LatexCommand;
import net.sourceforge.czt.parser.util.LatexMarkupFunction;
import net.sourceforge.czt.parser.util.MarkupException;
import net.sourceforge.czt.print.z.Unicode2Latex;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.util.ParseException;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.ZChar;
import net.sourceforge.czt.z.util.ZString;

class CUP$Unicode2Latex$actions {
    private Map sections_ = new HashMap();
    protected Map unicode2latexMap_ = null;
    protected Iterator markup_ = null;
    private final Unicode2Latex parser;

    private Map addStandardMapping(Map map) {
        map.put(ZString.SPOT, new LatexCommand("@", ZString.SPOT, true, true));
        map.put("+", new LatexCommand("+", "+", true, true));
        map.put(ZString.MINUS, new LatexCommand("-", ZString.MINUS, true, true));
        map.put("*", new LatexCommand("*", "*", true, true));
        map.put("|", new LatexCommand("|", "|", true, true));
        map.put(";", new LatexCommand(";", ";", false, true));
        map.put(",", new LatexCommand(",", ",", false, true));
        map.put(ZString.SE, new LatexCommand("_{", ZString.SE, false, false));
        map.put(ZString.NW, new LatexCommand("}", ZString.NW, false, false));
        map.put(ZString.NE, new LatexCommand("^{", ZString.NE, false, false));
        map.put(ZString.SW, new LatexCommand("}", ZString.SW, false, false));
        map.put(ZString.LL, new LatexCommand("\\_", ZString.LL, false, false));
        return map;
    }

    private String begin(String string) {
        return "\\begin{" + string + "}";
    }

    private String end(String string) {
        return "\n\\end{" + string + "}";
    }

    private LatexCommand concate(LatexCommand c1, LatexCommand c2) {
        if (c1 == null || c1.getUnicode().length() <= 0) {
            return c2;
        }
        if (c2 == null || c2.getUnicode().length() <= 0) {
            return c1;
        }
        String latex = c1.getName();
        if (!c1.addRightSpace() && !c2.addLeftSpace()) {
            boolean case2;
            ZChar[] unicode1 = ZChar.toZChars((String)c1.getUnicode());
            ZChar[] unicode2 = ZChar.toZChars((String)c2.getUnicode());
            ZChar lastChar = unicode1[unicode1.length - 1];
            ZChar firstChar = unicode2[0];
            boolean lastIsAlphaOrStroke = ZChar.isAlpha((ZChar)lastChar) || ZChar.isStroke((ZChar)lastChar);
            boolean firstIsAlphaOrStrokeOrWordglue = ZChar.isAlpha((ZChar)firstChar) || ZChar.isStroke((ZChar)firstChar) || ZChar.isWordGlue((ZChar)firstChar);
            boolean case1 = lastIsAlphaOrStroke && !firstIsAlphaOrStrokeOrWordglue;
            boolean lastIsAlphaOrStrokeOrWordglue = ZChar.isAlpha((ZChar)lastChar) || ZChar.isStroke((ZChar)lastChar) || ZChar.isWordGlue((ZChar)lastChar);
            boolean firstIsAlphaOrStroke = ZChar.isAlpha((ZChar)firstChar) || ZChar.isStroke((ZChar)firstChar);
            boolean bl = case2 = !lastIsAlphaOrStrokeOrWordglue && firstIsAlphaOrStroke;
            latex = case1 || case2 ? latex + " " : latex + "~";
        } else {
            latex = latex + " ";
        }
        latex = latex + c2.getName();
        String unicode = c1.getUnicode() + " " + c2.getUnicode();
        return new LatexCommand(latex, unicode, c1.addLeftSpace(), c2.addRightSpace());
    }

    private LatexCommand toLatex(String s, int line, int column) throws ParseException {
        try {
            assert (this.unicode2latexMap_ != null);
            return this.uniwordToLatex(s, this.unicode2latexMap_);
        }
        catch (ParseException e) {
            e.setLine(line);
            e.setColumn(column + e.getColumn());
            throw e;
        }
    }

    private String toLatexInSectHead(String s) {
        return s.replaceAll("_", "\\\\_");
    }

    private LatexCommand uniwordToLatex(String word, Map latexCommands) throws ParseException {
        LatexCommand command = null;
        if (this.markup_ == null) {
            Object o = latexCommands.get(word);
            if (o instanceof LatexMarkupFunction.MarkupDirective) {
                LatexMarkupFunction.MarkupDirective directive = (LatexMarkupFunction.MarkupDirective)o;
                command = new LatexCommand(directive.getCommand(), directive.getUnicode(), directive.addLeftSpace(), directive.addRightSpace());
            } else {
                command = (LatexCommand)o;
            }
            if (command != null) {
                return command;
            }
        }
        String latex = "";
        boolean addLeftSpace = false;
        boolean addRightSpace = false;
        ZChar[] zchars = ZChar.toZChars((String)word);
        int charcount = 0;
        for (int i = 0; i < zchars.length; ++i) {
            ZChar zchar = zchars[i];
            Object o = latexCommands.get(zchar.toString());
            if (o instanceof LatexMarkupFunction.MarkupDirective) {
                LatexMarkupFunction.MarkupDirective directive = (LatexMarkupFunction.MarkupDirective)o;
                command = new LatexCommand(directive.getCommand(), directive.getUnicode(), directive.addLeftSpace(), directive.addRightSpace());
            } else {
                command = (LatexCommand)o;
            }
            if (command != null) {
                latex = command.addLeftSpace() && i > 0 || command.addRightSpace() && i + 1 < zchars.length ? latex + "{" + command.getName() + "}" : latex + command.getName() + " ";
                addRightSpace = command.addRightSpace();
            } else if (zchar.isAsciiChar()) {
                latex = latex + zchar.toString();
            } else if (ZChar.PRIME.equals((Object)zchar)) {
                latex = latex + "'";
            } else {
                int hexBase = 16;
                String hex = Integer.toString(zchar.codePoint(), 16);
                String message = "Error while transforming " + word + ": Unexpected character " + zchar.toString() + " (\\u" + hex + ")";
                throw new ParseException(message, 0, charcount);
            }
            charcount += zchar.charCount();
        }
        return new LatexCommand(latex, word, addLeftSpace, addRightSpace);
    }

    protected List list(Object o) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(o);
        return result;
    }

    private void addParentMarkups(ZSect zsect, LatexMarkupFunction table) {
        for (Parent parent : zsect.getParent()) {
            String parentName = parent.getWord();
            LatexMarkupFunction parentMarkup = null;
            try {
                parentMarkup = (LatexMarkupFunction)this.parser.sectInfo_.get(new Key(parentName, LatexMarkupFunction.class));
            }
            catch (CommandException exception) {
                // empty catch block
            }
            if (parentMarkup == null) {
                ZSect parentHeader = (ZSect)this.sections_.get(parentName);
                if (parentHeader == null) continue;
                this.addParentMarkups(parentHeader, table);
                continue;
            }
            try {
                table.add(parentMarkup);
            }
            catch (MarkupException e) {
                CztLogger.getLogger(Unicode2Latex.class).warning(e.getMessage());
            }
        }
    }

    protected void setupMarkupTable(ZSect zsect) {
        String sectName = zsect.getName();
        LatexMarkupFunction table = null;
        try {
            table = (LatexMarkupFunction)this.parser.sectInfo_.get(new Key(sectName, LatexMarkupFunction.class));
        }
        catch (CommandException exception) {
            // empty catch block
        }
        if (table != null) {
            LatexMarkupPara para = table.toAst((ZFactory)new ZFactoryImpl());
            this.markup_ = para.getDirective().iterator();
        } else {
            table = new LatexMarkupFunction(zsect.getName());
            this.addParentMarkups(zsect, table);
        }
        assert (table != null);
        this.unicode2latexMap_ = this.toUnicode2LatexMap(table);
        this.addStandardMapping(this.unicode2latexMap_);
    }

    protected Map toUnicode2LatexMap(LatexMarkupFunction table) {
        HashMap<String, LatexMarkupFunction.MarkupDirective> result = new HashMap<String, LatexMarkupFunction.MarkupDirective>();
        if (table != null) {
            Iterator iter = table.iterator();
            while (iter.hasNext()) {
                LatexMarkupFunction.MarkupDirective directive = (LatexMarkupFunction.MarkupDirective)iter.next();
                result.put(directive.getUnicode(), directive);
            }
        }
        return result;
    }

    CUP$Unicode2Latex$actions(Unicode2Latex parser) {
        this.parser = parser;
    }

    public final Symbol CUP$Unicode2Latex$do_action(int CUP$Unicode2Latex$act_num, lr_parser CUP$Unicode2Latex$parser, Stack CUP$Unicode2Latex$stack, int CUP$Unicode2Latex$top) throws Exception {
        switch (CUP$Unicode2Latex$act_num) {
            case 45: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\\\\n", ZString.NL, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(12, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 44: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\rdata", ZString.RDATA, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 43: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\ldata", ZString.LDATA, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 42: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\rblot", ZString.RBIND, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 41: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\lblot", ZString.LBIND, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 40: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\}", ZString.RBRACE, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 39: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("\\{", ZString.LBRACE, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 38: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("]", ZString.RSQUARE, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 37: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("[", ZString.LSQUARE, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 36: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand(")", ZString.RPAREN, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 35: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("(", ZString.LPAREN, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(11, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 34: {
                LatexCommand RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                Decorword s = (Decorword)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                assert (s != null);
                RESULT = this.toLatex(s.getName(), sleft, sright);
                Symbol CUP$Unicode2Latex$result = new Symbol(13, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 33: {
                LatexCommand RESULT = null;
                int tleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int tright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                Object t = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = new LatexCommand("\n\\where\n", ZString.VL, true, true);
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 32: {
                LatexCommand s;
                LatexCommand RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                RESULT = s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 31: {
                LatexCommand RESULT = null;
                int ileft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int iright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                Integer i = (Integer)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = new LatexCommand(i.toString(), i.toString(), false, false);
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 30: {
                LatexCommand RESULT = null;
                int ileft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int iright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                Integer i = (Integer)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                String latex = "^" + i.toString();
                String unicode = ZString.SE + i.toString() + ZString.NW;
                RESULT = new LatexCommand(latex, unicode, false, false);
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 29: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("'", ZString.PRIME, false, false);
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 28: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("!", ZString.OUTSTROKE, false, false);
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 27: {
                LatexCommand RESULT = null;
                RESULT = new LatexCommand("?", ZString.INSTROKE, false, false);
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 26: {
                LatexCommand s;
                LatexCommand RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                RESULT = s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                Symbol CUP$Unicode2Latex$result = new Symbol(9, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 25: {
                Object RESULT = null;
                RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(10, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 24: {
                LatexCommand RESULT = null;
                int w1left = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int w1right = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand w1 = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                int w2left = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int w2right = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                LatexCommand w2 = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = this.concate(w1, w2);
                Symbol CUP$Unicode2Latex$result = new Symbol(10, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 23: {
                LatexCommand RESULT = null;
                int w1left = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int w1right = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand w1 = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                int w2left = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int w2right = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                LatexCommand w2 = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = this.concate(w1, w2);
                Symbol CUP$Unicode2Latex$result = new Symbol(10, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 22: {
                String RESULT = null;
                int postwordleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int postwordright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                String postword = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = "%%Zpostword " + postword;
                Symbol CUP$Unicode2Latex$result = new Symbol(8, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 21: {
                String RESULT = null;
                int prewordleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int prewordright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                String preword = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = "%%Zpreword " + preword;
                Symbol CUP$Unicode2Latex$result = new Symbol(8, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 20: {
                String RESULT = null;
                int inwordleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int inwordright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                String inword = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = "%%Zinword " + inword;
                Symbol CUP$Unicode2Latex$result = new Symbol(8, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 19: {
                String RESULT = null;
                int wordleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int wordright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                String word = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                RESULT = "%%Zword " + word;
                Symbol CUP$Unicode2Latex$result = new Symbol(8, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, (Object)RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 18: {
                Object RESULT = null;
                int wmleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left;
                int wmright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).right;
                String wm = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).value;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                StringBuffer result = new StringBuffer();
                result.append("\n");
                result.append(wm);
                result.append(" ");
                if (s != null) {
                    result.append(s.getName());
                }
                result.append("\n");
                this.parser.write(result.toString());
                Symbol CUP$Unicode2Latex$result = new Symbol(6, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 17: {
                Object RESULT = null;
                int zcharleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int zcharright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                String zchar = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                this.parser.write(zchar);
                Symbol CUP$Unicode2Latex$result = new Symbol(6, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 16: {
                Object RESULT = null;
                int wleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left;
                int wright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).right;
                LatexCommand w = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).value;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                String result = this.begin("schema") + "{" + w.getName() + "}";
                if (s != null) {
                    result = result + s.getName();
                }
                result = result + this.end("schema");
                this.parser.write(result);
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 3))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 15: {
                Object RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                String result = this.begin("gendef");
                if (s != null) {
                    result = result + s.getName();
                }
                result = result + this.end("gendef");
                this.parser.write(result);
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 14: {
                Object RESULT = null;
                int wleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left;
                int wright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).right;
                LatexCommand w = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).value;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                String result = this.begin("schema") + "{" + w.getName() + "}";
                if (s != null) {
                    result = result + s.getName();
                }
                result = result + this.end("schema");
                this.parser.write(result);
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 3))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 13: {
                Object RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                String result = this.begin("axdef");
                if (s != null) {
                    result = result + s.getName();
                }
                result = result + this.end("axdef");
                this.parser.write(result);
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 12: {
                Object RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                String result = this.begin("zed");
                if (s != null) {
                    result = result + s.getName();
                }
                result = result + this.end("zed");
                this.parser.write(result);
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 11: {
                Object RESULT = null;
                int tleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int tright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                String t = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                this.parser.write(t);
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 10: {
                Object RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(7, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 9: {
                Object RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(5, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 8: {
                Object RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(5, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 7: {
                Object RESULT = null;
                int zsectleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int zsectright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                ZSect zsect = (ZSect)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                this.sections_.put(zsect.getName(), zsect);
                this.parser.write(this.begin("zsection"));
                String latexName = this.toLatexInSectHead(zsect.getName());
                this.parser.write("\\SECTION " + latexName + " \\parents ");
                Iterator iter = zsect.getParent().iterator();
                while (iter.hasNext()) {
                    Parent parent = (Parent)iter.next();
                    String parentLatexName = this.toLatexInSectHead(parent.getWord());
                    this.parser.write(parentLatexName);
                    if (!iter.hasNext()) continue;
                    this.parser.write(", ");
                }
                this.parser.write(this.end("zsection"));
                Symbol CUP$Unicode2Latex$result = new Symbol(3, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 6: {
                Object RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(4, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 5: {
                Object RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(4, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 4: {
                Object RESULT = null;
                Symbol CUP$Unicode2Latex$result = new Symbol(2, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 3: {
                Object RESULT = null;
                int tleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int tright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                String t = (String)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                this.parser.write(t);
                Symbol CUP$Unicode2Latex$result = new Symbol(2, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 2: {
                Object RESULT = null;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                LatexCommand s = (LatexCommand)((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                if (s != null) {
                    this.parser.write(s.getName());
                }
                this.parser.getWriter().flush();
                Symbol CUP$Unicode2Latex$result = new Symbol(1, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 2))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
            case 1: {
                Object start_val;
                Object RESULT = null;
                int start_valleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int start_valright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                RESULT = start_val = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                Symbol CUP$Unicode2Latex$result = new Symbol(0, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                CUP$Unicode2Latex$parser.done_parsing();
                return CUP$Unicode2Latex$result;
            }
            case 0: {
                Object RESULT = null;
                int narrleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left;
                int narrright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).right;
                Object narr = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).value;
                int sleft = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).left;
                int sright = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right;
                Object s = ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).value;
                this.parser.getWriter().flush();
                Symbol CUP$Unicode2Latex$result = new Symbol(1, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 1))).left, ((Symbol)CUP$Unicode2Latex$stack.elementAt((int)(CUP$Unicode2Latex$top - 0))).right, RESULT);
                return CUP$Unicode2Latex$result;
            }
        }
        throw new Exception("Invalid action number found in internal parse table");
    }
}

