/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.circus;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Logger;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.jaxb.JaxbValidator;
import net.sourceforge.czt.circus.jaxb.JaxbXmlWriter;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.circus.Parser;
import net.sourceforge.czt.parser.circus.UnicodeScanner;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.util.CztLogger;

public class UnicodeParser {
    Parser parser_;

    public UnicodeParser(Reader in, SectionInfo sectInfo, Properties properties) {
        this(in, null, sectInfo, properties);
    }

    public UnicodeParser(Reader in, String filename, SectionInfo sectInfo, Properties properties) {
        UnicodeScanner scanner = new UnicodeScanner(in, properties);
        this.parser_ = new Parser(scanner, filename, sectInfo);
    }

    public static void main(String[] args) {
        String usage = "Usage: net.sourceforge.czt.parser.circus.UnicodeParser [ -in <inputfile>] [ -out <outputfile>]";
        try {
            String filename = null;
            Logger logger = CztLogger.getLogger(UnicodeParser.class);
            InputStreamReader in = new InputStreamReader(System.in);
            OutputStream out = System.out;
            for (int i = 0; i < args.length; ++i) {
                if ("-in".equals(args[i])) {
                    if (i < args.length) {
                        filename = args[++i];
                        in = new InputStreamReader(new FileInputStream(filename));
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                if ("-out".equals(args[i])) {
                    if (i < args.length) {
                        out = new FileOutputStream(args[++i]);
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                System.err.println(usage);
                return;
            }
            JaxbValidator validator = new JaxbValidator();
            UnicodeParser parser = new UnicodeParser(in, filename, new SectionManager(), new Properties());
            Term term = parser.parse();
            if (!validator.validate(term)) {
                String message = "AST is not valid.";
                logger.warning(message);
            }
            JaxbXmlWriter xmlWriter = new JaxbXmlWriter();
            xmlWriter.write(term, out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Term parse() throws ParseException {
        try {
            Symbol parseTree = this.parser_.parse();
            return (Term)parseTree.value;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("This should never happen", e);
        }
    }
}

