/*
 * Decompiled with CFR 0.152.
 */
package ant;

import ant.StreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.java_cup.emit;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class JavaCupTask
extends Task {
    private String inputFile_;
    private String parserFile_;
    private String symbolFile_;
    private String srcDir_;
    private String destDir_;
    private boolean debug_ = false;
    private Path classpath_;
    PumpStreamHandler handler = new PumpStreamHandler();

    public void execute() throws BuildException {
        try {
            if (this.inputFile_ == null) {
                throw new BuildException("An input file must be specified");
            }
            String inputFileFull = new String();
            if (this.srcDir_ != null) {
                inputFileFull = inputFileFull + this.srcDir_ + File.separator;
            }
            inputFileFull = inputFileFull + this.inputFile_;
            String parserFileFull = new String();
            String symbolFileFull = new String();
            if (this.destDir_ != null) {
                parserFileFull = parserFileFull + this.destDir_ + File.separator;
                symbolFileFull = symbolFileFull + this.destDir_ + File.separator;
            }
            if (this.parserFile_ == null) {
                this.parserFile_ = this.parserFile_ + emit.parser_class_name;
            }
            parserFileFull = parserFileFull + this.parserFile_;
            if (this.symbolFile_ == null) {
                this.symbolFile_ = this.symbolFile_ + emit.symbol_const_class_name;
            }
            symbolFileFull = symbolFileFull + this.symbolFile_;
            File fInputFile = new File(inputFileFull);
            File fParserFile = new File(parserFileFull + ".java");
            File fSymbolFile = new File(symbolFileFull + ".java");
            if (fInputFile.lastModified() > fParserFile.lastModified()) {
                ArrayList<String> cmdarray = new ArrayList<String>();
                cmdarray.add("java");
                if (this.classpath_ != null) {
                    cmdarray.add("-classpath");
                    cmdarray.add(this.classpath_.toString());
                }
                cmdarray.add("net.sourceforge.czt.java_cup.Main");
                cmdarray.add("-parser");
                cmdarray.add(this.parserFile_);
                cmdarray.add("-symbols");
                cmdarray.add(this.symbolFile_);
                if (this.debug_) {
                    cmdarray.add("-debug");
                }
                Process process = Runtime.getRuntime().exec(this.toStringArray(cmdarray));
                this.handler.setProcessOutputStream(process.getInputStream());
                this.handler.setProcessErrorStream(process.getErrorStream());
                FileInputStream inputStream = new FileInputStream(inputFileFull);
                StreamWriter streamWriter = new StreamWriter(process.getOutputStream(), inputStream);
                this.handler.start();
                streamWriter.write();
                process.waitFor();
                String intermediateParserFile = new String();
                String intermediateSymbolFile = new String();
                intermediateParserFile = intermediateParserFile + this.parserFile_ + ".java";
                intermediateSymbolFile = intermediateSymbolFile + this.symbolFile_ + ".java";
                boolean pMoved = new File(intermediateParserFile).renameTo(fParserFile);
                boolean sMoved = new File(intermediateSymbolFile).renameTo(fSymbolFile);
                if (!pMoved) {
                    String error = "Parser could not be written to " + fParserFile.getAbsolutePath();
                    throw new Exception(error);
                }
                System.out.println("Parser written to " + fParserFile.getAbsolutePath());
                if (!sMoved) {
                    String error = "Symbols could not be written to " + fSymbolFile.getAbsolutePath();
                    throw new Exception(error);
                }
                System.out.println("Symbols written to " + fSymbolFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Java cup failed!", (Throwable)e);
        }
    }

    public void setDestdir(String destDir) {
        this.destDir_ = destDir;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir_ = srcDir;
    }

    public void setInputFile(String inputFile) {
        this.inputFile_ = inputFile;
    }

    public void setParserFile(String parserFile) {
        this.parserFile_ = parserFile;
    }

    public void setSymbolFile(String symbolFile) {
        this.symbolFile_ = symbolFile;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath_ == null) {
            this.classpath_ = classpath;
        } else {
            classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        if (this.classpath_ == null) {
            this.classpath_ = new Path(this.getProject());
        }
        this.classpath_.createPath().setRefid(classpathRef);
    }

    private String[] toStringArray(List list) {
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String next;
            result[i] = next = (String)list.get(i);
        }
        return result;
    }
}

