/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.sourceforge.czt.print.z.ContextFreeScanner;
import net.sourceforge.czt.print.z.NewlineScanner;
import net.sourceforge.czt.print.z.SectHeadScanner;
import net.sourceforge.czt.print.z.Unicode2Latex;

public final class UnicodeToLatex {
    private UnicodeToLatex() {
    }

    public static void main(String[] args) {
        String usage = "Usage: java net.sourceforge.czt.scanner.UnicodeToLatex [ -in <inputfile>] [ -out <outputfile>] [-enc <encoding>]";
        String infile = null;
        String encoding = null;
        String outfile = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-in".equals(args[i])) {
                if (i < args.length) {
                    infile = args[++i];
                    continue;
                }
                System.err.println(usage);
                return;
            }
            if ("-out".equals(args[i])) {
                if (i >= args.length) continue;
                outfile = args[++i];
                continue;
            }
            if ("-enc".equals(args[i])) {
                if (i < args.length) {
                    encoding = args[++i];
                    continue;
                }
                System.err.println(usage);
                return;
            }
            System.err.println(usage);
            return;
        }
        try {
            UnicodeToLatex.run(infile, encoding, outfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run(String infile, String encoding, String outfile) throws Exception {
        InputStream instream = System.in;
        String enc = "UTF-8";
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        if (infile != null) {
            instream = new FileInputStream(infile);
        }
        if (encoding != null) {
            enc = encoding;
        }
        if (outfile != null) {
            writer = new OutputStreamWriter(new FileOutputStream(outfile));
        }
        UnicodeToLatex.run(new InputStreamReader(instream, enc), writer);
        ((Writer)writer).flush();
        if (outfile != null) {
            ((Writer)writer).close();
        }
    }

    public static void run(Reader in, Writer out) throws Exception {
        Unicode2Latex parser = new Unicode2Latex(new SectHeadScanner(new NewlineScanner(new ContextFreeScanner(in))));
        parser.setWriter(out);
        Object result = parser.parse().value;
    }
}

