/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.parser.util.TokenStack;
import net.sourceforge.czt.util.ParseException;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.ZString;

public class SectHeadScanner
implements Scanner {
    private TokenStack lookahead_;
    private ZFactory factory_ = new ZFactoryImpl();
    private ZSect sectHead_ = null;
    private static final String ANONYMOUS_SECT_NAME = "Specification";
    private static final String ANONYMOUS_PARENT = "standard_toolkit";

    public SectHeadScanner(Scanner scanner) {
        this.lookahead_ = new TokenStack(scanner);
    }

    public Symbol next_token() throws Exception {
        Symbol result = this.lookahead_.pop();
        if (result != null && result.sym != 30) {
            Symbol nextToken = this.lookahead_.pop();
            if (this.isSectHead(result, nextToken)) {
                this.sectHead_ = this.parseSectHead();
                assert (this.sectHead_ != null);
                return new Symbol(27, result.left, result.right, (Object)this.sectHead_);
            }
            if (this.sectHead_ == null) {
                this.lookahead_.push(nextToken);
                this.lookahead_.push(result);
                this.sectHead_ = this.anonymousZSect();
                assert (this.sectHead_ != null);
                return new Symbol(27, (Object)this.sectHead_);
            }
            this.lookahead_.push(nextToken);
        }
        return result;
    }

    private ZSect anonymousZSect() {
        Parent parent = this.factory_.createParent(ANONYMOUS_PARENT);
        ArrayList<Parent> parentlist = new ArrayList<Parent>();
        parentlist.add(parent);
        ZSect result = this.factory_.createZSect(ANONYMOUS_SECT_NAME, parentlist, null);
        return result;
    }

    private boolean isSectHead(Symbol first, Symbol second) {
        boolean firstIsZed = first != null && first.sym == 12;
        boolean secondIsSection = second != null && second.sym == 19;
        return firstIsZed && secondIsSection;
    }

    private ZSect parseSectHead() throws Exception {
        Symbol nametok = this.lookahead_.pop();
        Symbol next = this.lookahead_.pop();
        if (nametok == null || next == null) {
            throw new ParseException("Parse error", -1, -1);
        }
        if (nametok.sym != 36) {
            String message = "Parse error (expected DECORWORD)";
            throw new ParseException(message, nametok.left, nametok.right);
        }
        assert (nametok.value != null);
        String name = ((Decorword)nametok.value).getName();
        assert (name.length() > 0);
        ZSect result = this.factory_.createZSect(name, null, null);
        if (next.sym == 20) {
            this.parseParentList((List)result.getParent());
        } else if (next.sym != 17) {
            String message = "Parse error (expected PARENTS or END)";
            throw new ParseException(message, next.left, next.right);
        }
        assert (result != null);
        return result;
    }

    private void parseParentList(List parentList) throws Exception {
        Symbol parentName = this.lookahead_.pop();
        Symbol next = this.lookahead_.pop();
        if (parentName == null || next == null) {
            throw new ParseException("Parse error", -1, -1);
        }
        if (parentName.sym != 36) {
            throw new ParseException("Parse error", parentName.left, parentName.right);
        }
        String name = ((Decorword)parentName.value).getName();
        Parent parent = this.factory_.createParent(name);
        parentList.add(parent);
        if (next.sym == 36 && ZString.COMMA.equals(((Decorword)next.value).getName())) {
            this.parseParentList(parentList);
        } else if (next.sym != 17) {
            throw new ParseException("Parse error", next.left, next.right);
        }
    }

    public static boolean isAnonymous(ZSect zsect) {
        boolean result = false;
        String name = zsect.getName();
        ListTerm parents = zsect.getParent();
        if (parents.size() == 1) {
            Parent parent = (Parent)parents.get(0);
            String parentName = parent.getWord();
            if (ANONYMOUS_SECT_NAME.equals(name) && ANONYMOUS_PARENT.equals(parentName)) {
                result = true;
            }
        }
        return result;
    }
}

