/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.io.Writer;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.print.z.AstToPrintTreeVisitor;
import net.sourceforge.czt.print.z.SectHeadScanner;
import net.sourceforge.czt.print.z.Unicode2Latex;
import net.sourceforge.czt.print.z.UnicodePrinter;
import net.sourceforge.czt.print.z.ZmlScanner;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.Visitor;

public final class PrintUtils {
    private PrintUtils() {
    }

    public static void print(Term term, Writer out, SectionInfo sectInfo, Markup markup) {
        if (markup == Markup.LATEX) {
            PrintUtils.printLatex(term, out, sectInfo);
        } else if (markup == Markup.UNICODE) {
            PrintUtils.printUnicode(term, out, sectInfo);
        } else {
            String message = "Attempt to print unsupported markup";
            throw new UnsupportedOperationException(message);
        }
    }

    public static void print(Term term, Writer out, SectionInfo sectInfo, String sectName, Markup markup) {
        if (markup == Markup.LATEX) {
            PrintUtils.printLatex(term, out, sectInfo, sectName);
        } else if (markup == Markup.UNICODE) {
            PrintUtils.printUnicode(term, out, sectInfo, sectName);
        } else {
            String message = "Attempt to print unsupported markup";
            throw new UnsupportedOperationException(message);
        }
    }

    public static void printLatex(Term term, Writer out, SectionInfo sectInfo) {
        AstToPrintTreeVisitor toPrintTree = new AstToPrintTreeVisitor(sectInfo);
        Term tree = (Term)term.accept((Visitor)toPrintTree);
        ZmlScanner scanner = new ZmlScanner(tree);
        Unicode2Latex parser = new Unicode2Latex(new SectHeadScanner(scanner));
        parser.setSectionInfo(sectInfo);
        UnicodePrinter printer = new UnicodePrinter(out);
        parser.setWriter(printer);
        try {
            parser.parse();
        }
        catch (Exception e) {
            throw new CztException((Throwable)e);
        }
    }

    public static void printLatex(Term term, Writer out, SectionInfo sectInfo, String sectionName) {
        Term tree;
        AstToPrintTreeVisitor toPrintTree = new AstToPrintTreeVisitor(sectInfo);
        try {
            tree = toPrintTree.run(term, sectionName);
        }
        catch (CommandException exception) {
            throw new CztException((Throwable)exception);
        }
        ZmlScanner scanner = new ZmlScanner(tree);
        scanner.prepend(new Symbol(26));
        scanner.append(new Symbol(26));
        Unicode2Latex parser = new Unicode2Latex(scanner);
        parser.setSectionInfo(sectInfo, sectionName);
        UnicodePrinter printer = new UnicodePrinter(out);
        parser.setWriter(printer);
        try {
            parser.parse();
        }
        catch (Exception e) {
            throw new CztException((Throwable)e);
        }
    }

    public static void printUnicode(Term term, Writer out, SectionInfo sectInfo) {
        AstToPrintTreeVisitor toPrintTree = new AstToPrintTreeVisitor(sectInfo);
        Term tree = (Term)term.accept((Visitor)toPrintTree);
        ZmlScanner scanner = new ZmlScanner(tree);
        UnicodePrinter printer = new UnicodePrinter(out);
        printer.printZed(scanner);
    }

    public static void printUnicode(Term term, Writer out, SectionInfo sectInfo, String sectionName) {
        Term tree;
        AstToPrintTreeVisitor toPrintTree = new AstToPrintTreeVisitor(sectInfo);
        try {
            tree = toPrintTree.run(term, sectionName);
        }
        catch (CommandException exception) {
            throw new CztException((Throwable)exception);
        }
        ZmlScanner scanner = new ZmlScanner(tree);
        UnicodePrinter printer = new UnicodePrinter(out);
        printer.printZed(scanner);
    }
}

