/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.base.visitor.TermAVisitor;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.parser.util.OpTable;
import net.sourceforge.czt.print.ast.Application;
import net.sourceforge.czt.print.ast.OperatorApplication;
import net.sourceforge.czt.print.ast.Precedence;
import net.sourceforge.czt.print.ast.PrintParagraph;
import net.sourceforge.czt.print.ast.PrintPredicate;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Assoc;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Box;
import net.sourceforge.czt.z.ast.Cat;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Op;
import net.sourceforge.czt.z.ast.ParenAnn;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.OperatorName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.AndPredVisitor;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.AxParaVisitor;
import net.sourceforge.czt.z.visitor.MemPredVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.ZSectVisitor;

public class AstToPrintTreeVisitor
implements TermVisitor,
TermAVisitor,
AndPredVisitor,
ApplExprVisitor,
AxParaVisitor,
MemPredVisitor,
RefExprVisitor,
ZSectVisitor {
    private ZFactory factory_ = new ZFactoryImpl();
    private OpTable opTable_;
    private SectionInfo sectInfo_;

    public AstToPrintTreeVisitor(SectionInfo sectInfo) {
        this.sectInfo_ = sectInfo;
    }

    public Term run(String sectionName) throws CommandException {
        ZSect zSect = (ZSect)this.sectInfo_.get(new Key(sectionName, ZSect.class));
        return (Term)zSect.accept((Visitor)this);
    }

    public Term run(Term term, OpTable opTable) {
        this.opTable_ = opTable;
        return (Term)term.accept((Visitor)this);
    }

    public Term run(Term term, String sectionName) throws CommandException {
        this.opTable_ = (OpTable)this.sectInfo_.get(new Key(sectionName, OpTable.class));
        return (Term)term.accept((Visitor)this);
    }

    public Object visitTerm(Term term) {
        Term result = (Term)VisitorUtils.visitTerm((Visitor)this, (Term)term, (boolean)true);
        return result;
    }

    public Object visitTermA(TermA termA) {
        TermA result = (TermA)VisitorUtils.visitTerm((Visitor)this, (Term)termA, (boolean)true);
        if (result != termA) {
            result.getAnns().addAll((Collection)termA.getAnns());
        }
        return result;
    }

    public Object visitAndPred(AndPred andPred) {
        ArrayList<Object> list = new ArrayList<Object>();
        Precedence prec = new Precedence(60);
        if (Op.And.equals((Object)andPred.getOp())) {
            list.add(this.visit(andPred.getLeftPred()));
            list.add(ZString.AND);
            list.add(this.visit(andPred.getRightPred()));
        } else if (Op.Chain.equals((Object)andPred.getOp())) {
            int i;
            Object[] array2;
            PrintPredicate pred1 = (PrintPredicate)((Object)this.visit(andPred.getLeftPred()));
            PrintPredicate pred2 = (PrintPredicate)((Object)this.visit(andPred.getRightPred()));
            Object[] array1 = pred1.getChildren();
            if (!array1[array1.length - 1].equals((array2 = pred2.getChildren())[0])) {
                String message = "Unexpected Op == 'Chain' within AndPred.";
                throw new CannotPrintAstException(message);
            }
            for (i = 0; i < array1.length; ++i) {
                list.add(array1[i]);
            }
            for (i = 1; i < array2.length; ++i) {
                list.add(array2[i]);
            }
        } else if (Op.NL.equals((Object)andPred.getOp())) {
            prec = new Precedence(10);
            list.add(this.visit(andPred.getLeftPred()));
            list.add(ZString.NL);
            list.add(this.visit(andPred.getRightPred()));
        } else if (Op.Semi.equals((Object)andPred.getOp())) {
            prec = new Precedence(10);
            list.add(this.visit(andPred.getLeftPred()));
            list.add(ZString.SEMICOLON);
            list.add(this.visit(andPred.getRightPred()));
        } else {
            throw new CztException("Unexpected Op");
        }
        PrintPredicate result = new PrintPredicate(list, prec, null);
        if (andPred.getAnn(ParenAnn.class) != null) {
            result.getAnns().add((Object)this.factory_.createParenAnn());
        }
        return result;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        boolean isFunctionApplication = applExpr.getMixfix();
        if (isFunctionApplication) {
            RefExpr refExpr = (RefExpr)applExpr.getLeftExpr();
            OperatorName opName = refExpr.getRefName().getOperatorName();
            Expr args = (Expr)applExpr.getRightExpr().accept((Visitor)this);
            ArrayList<Expr> argList = new ArrayList<Expr>();
            if (opName.isUnary()) {
                argList.add(args);
            } else {
                TupleExpr tuple = (TupleExpr)args;
                argList.addAll((Collection<Expr>)tuple.getExpr());
            }
            return this.createOperatorApplication(opName, argList);
        }
        Expr leftExpr = (Expr)applExpr.getLeftExpr().accept((Visitor)this);
        Expr rightExpr = (Expr)applExpr.getRightExpr().accept((Visitor)this);
        Application appl = new Application();
        appl.setLeftExpr(leftExpr);
        appl.setRightExpr(rightExpr);
        return appl;
    }

    public Object visitAxPara(AxPara axPara) {
        ArrayList<Object> list = new ArrayList<Object>();
        Box box = axPara.getBox();
        if (box == null || Box.AxBox.equals((Object)box)) {
            if (!this.isGeneric(axPara)) {
                list.add(ZString.AX);
            } else {
                list.add(ZString.GENAX);
                list.add(ZString.LSQUARE);
                Iterator iter = axPara.getDeclName().iterator();
                while (iter.hasNext()) {
                    list.add(this.visit(iter.next()));
                    if (!iter.hasNext()) continue;
                    list.add(ZString.COMMA);
                }
                list.add(ZString.RSQUARE);
            }
            SchText schText = axPara.getSchText();
            Iterator iter = schText.getDecl().iterator();
            while (iter.hasNext()) {
                list.add(this.visit(iter.next()));
                if (!iter.hasNext()) continue;
                list.add(ZString.NL);
            }
            if (schText.getPred() != null) {
                list.add("|");
                list.add(this.visit(schText.getPred()));
            }
            list.add(ZString.END);
        } else if (Box.OmitBox.equals((Object)box)) {
            list.add(ZString.ZED);
            ListTerm declNameList = axPara.getDeclName();
            if (declNameList.size() > 0) {
                OpTable.OpInfo opInfo;
                SchText schText = axPara.getSchText();
                ListTerm decls = axPara.getSchText().getDecl();
                ConstDecl constDecl = (ConstDecl)decls.get(0);
                DeclName declName = constDecl.getDeclName();
                OperatorName operatorName = declName.getOperatorName();
                OpTable.OpInfo opInfo2 = opInfo = operatorName == null ? null : this.opTable_.lookup(operatorName);
                if (opInfo != null && Cat.Generic.equals((Object)opInfo.getCat())) {
                    list.addAll(this.printOperator(operatorName, axPara.getDeclName()));
                    list.add("==");
                    list.add(this.visit(constDecl.getExpr()));
                } else {
                    list.add(this.visit(declName));
                    list.add(ZString.LSQUARE);
                    Iterator iter = declNameList.iterator();
                    while (iter.hasNext()) {
                        list.add(this.visit(iter.next()));
                        if (!iter.hasNext()) continue;
                        list.add(ZString.COMMA);
                    }
                    list.add(ZString.RSQUARE);
                    list.add("==");
                    list.add(this.visit(constDecl.getExpr()));
                }
            } else {
                list.add(this.visit(axPara.getSchText()));
            }
            list.add(ZString.END);
        } else {
            if (Box.SchBox.equals((Object)box)) {
                return this.handleSchemaDefinition(axPara);
            }
            throw new CztException("Unexpected Box " + box);
        }
        return new PrintParagraph(list);
    }

    private PrintParagraph handleSchemaDefinition(AxPara axPara) {
        ArrayList<Object> list = new ArrayList<Object>();
        assert (Box.SchBox.equals((Object)axPara.getBox()));
        if (this.isGeneric(axPara)) {
            list.add(ZString.GENSCH);
        } else {
            list.add(ZString.SCH);
        }
        ListTerm decls = axPara.getSchText().getDecl();
        ConstDecl cdecl = (ConstDecl)decls.get(0);
        String declName = cdecl.getDeclName().getWord();
        if (declName == null) {
            throw new CztException();
        }
        list.add(this.visit(declName));
        if (this.isGeneric(axPara)) {
            list.add(ZString.LSQUARE);
            Iterator iter = axPara.getDeclName().iterator();
            while (iter.hasNext()) {
                list.add(this.visit(iter.next()));
                if (!iter.hasNext()) continue;
                list.add(ZString.COMMA);
            }
            list.add(ZString.RSQUARE);
        }
        SchExpr schExpr = (SchExpr)cdecl.getExpr();
        SchText schText = schExpr.getSchText();
        Iterator iter = schText.getDecl().iterator();
        while (iter.hasNext()) {
            list.add(this.visit(iter.next()));
            if (!iter.hasNext()) continue;
            list.add(ZString.NL);
        }
        if (schText.getPred() != null) {
            list.add("|");
            list.add(this.visit(schText.getPred()));
        }
        list.add(ZString.END);
        return new PrintParagraph(list);
    }

    private boolean isGeneric(AxPara axPara) {
        return !axPara.getDeclName().isEmpty();
    }

    public Object visitMemPred(MemPred memPred) {
        boolean isEquality;
        int prec = 80;
        Precedence precedence = new Precedence(80);
        Expr firstExpr = (Expr)this.visit(memPred.getLeftExpr());
        Expr secondExpr = (Expr)this.visit(memPred.getRightExpr());
        boolean mixfix = memPred.getMixfix();
        boolean bl = isEquality = mixfix && secondExpr instanceof SetExpr;
        if (isEquality) {
            SetExpr setExpr = (SetExpr)secondExpr;
            if (setExpr.getExpr().size() != 1) {
                String message = "Unexpected Mixfix == true.";
                throw new CannotPrintAstException(message);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(firstExpr);
            list.add("=");
            list.add(setExpr.getExpr().get(0));
            PrintPredicate result = new PrintPredicate(list, precedence, null);
            if (memPred.getAnn(ParenAnn.class) != null) {
                result.getAnns().add((Object)this.factory_.createParenAnn());
            }
            return result;
        }
        if (mixfix) {
            try {
                Expr operand = memPred.getLeftExpr();
                RefExpr operator = (RefExpr)memPred.getRightExpr();
                OperatorName op = new OperatorName((Name)operator.getRefName());
                return new PrintPredicate(this.printOperator(op, operand), precedence, null);
            }
            catch (Exception e) {
                throw new CannotPrintAstException(e.getMessage());
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.visit(memPred.getLeftExpr()));
        list.add(ZString.MEM);
        list.add(this.visit(memPred.getRightExpr()));
        PrintPredicate result = new PrintPredicate(list, precedence, null);
        if (memPred.getAnn(ParenAnn.class) != null) {
            result.getAnns().add((Object)this.factory_.createParenAnn());
        }
        return result;
    }

    public Object visitRefExpr(RefExpr refExpr) {
        boolean isGenericOperatorApplication = refExpr.getMixfix();
        if (isGenericOperatorApplication) {
            OperatorName opName = refExpr.getRefName().getOperatorName();
            ListTerm argList = (ListTerm)refExpr.getExpr().accept((Visitor)this);
            return this.createOperatorApplication(opName, (List)argList);
        }
        return VisitorUtils.visitTerm((Visitor)this, (Term)refExpr, (boolean)true);
    }

    public Object visitZSect(ZSect zSect) {
        String name = zSect.getName();
        try {
            this.opTable_ = (OpTable)this.sectInfo_.get(new Key(name, OpTable.class));
        }
        catch (CommandException exception) {
            String message = "Cannot get operator table for " + name + "; " + "try to print anyway ... ";
            this.printWarning(message);
        }
        if (this.opTable_ == null) {
            ArrayList<OpTable> parentOpTables = new ArrayList<OpTable>();
            for (Parent parent : zSect.getParent()) {
                OpTable parentOpTable = this.getOpTable(parent.getWord());
                if (parentOpTable == null) continue;
                parentOpTables.add(parentOpTable);
            }
            if (parentOpTables.size() > 0) {
                try {
                    this.opTable_ = new OpTable(zSect.getName(), parentOpTables);
                }
                catch (OpTable.OperatorException e) {
                    throw new CannotPrintAstException(e);
                }
            }
        }
        return this.visitTerm((Term)zSect);
    }

    protected boolean isPostfix(OperatorName opName) {
        if (opName == null) {
            return false;
        }
        return OperatorName.Fixity.POSTFIX.equals(opName.getFixity());
    }

    protected boolean isPrefix(OperatorName opName) {
        if (opName == null) {
            return false;
        }
        return OperatorName.Fixity.PREFIX.equals(opName.getFixity());
    }

    protected boolean isInfix(OperatorName opName) {
        if (opName == null) {
            return false;
        }
        return OperatorName.Fixity.INFIX.equals(opName.getFixity());
    }

    private OpTable getOpTable(String name) {
        try {
            return (OpTable)this.sectInfo_.get(new Key(name, OpTable.class));
        }
        catch (CommandException exception) {
            String message = "Cannot get operator table for " + name + "; " + "try to print anyway ... ";
            this.printWarning(message);
            return null;
        }
    }

    private void printWarning(String message) {
        CztLogger.getLogger(AstToPrintTreeVisitor.class).warning(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private OperatorApplication createOperatorApplication(OperatorName opName, List argList) {
        Precedence precedence = null;
        Assoc assoc = null;
        if (this.isInfix(opName)) {
            if (this.opTable_ == null) {
                String message = "Cannot find precedence and associativity for '" + opName + "'; no operator table available";
                throw new CannotPrintAstException(message);
            }
            OpTable.OpInfo opInfo = this.opTable_.lookup(opName);
            if (opInfo == null) {
                String message = "Cannot find precedence and associativity for '" + opName + "'.";
                throw new CannotPrintAstException(message);
            }
            if (opInfo.getPrec() == null) {
                String message = "Cannot find precedence of infix operator '" + opName + "'.";
                throw new CannotPrintAstException(message);
            }
            int prec = 180;
            precedence = new Precedence(180, opInfo.getPrec());
            assoc = opInfo.getAssoc();
            return new OperatorApplication(opName, argList, precedence, assoc);
        }
        if (this.isPostfix(opName)) {
            int prec = 200;
            precedence = new Precedence(200);
            return new OperatorApplication(opName, argList, precedence, assoc);
        }
        if (!this.isPrefix(opName)) return new OperatorApplication(opName, argList, precedence, assoc);
        int prec = 190;
        precedence = new Precedence(190);
        return new OperatorApplication(opName, argList, precedence, assoc);
    }

    private Object visit(Object object) {
        if (object instanceof Term) {
            return ((Term)object).accept((Visitor)this);
        }
        return object;
    }

    private List printOperator(OperatorName op, Object arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> args = new ArrayList();
        if (arguments instanceof List) {
            args = (List)arguments;
        } else if (op.isUnary()) {
            args.add(arguments);
        } else {
            if (!(arguments instanceof TupleExpr)) {
                String message = arguments.toString() + " not instance of TupleExpr";
                throw new CannotPrintAstException(message);
            }
            TupleExpr tuple = (TupleExpr)arguments;
            args = tuple.getExpr();
        }
        int pos = 0;
        for (String opPart : op) {
            if (opPart.equals(ZString.ARG)) {
                result.add(this.visit((Term)args.get(pos)));
                ++pos;
                continue;
            }
            if (opPart.equals(",,")) {
                Object arg = args.get(pos);
                if (!(arg instanceof SetExpr)) {
                    String message = "Expected SetExpr but got " + arg;
                    throw new CannotPrintAstException(message);
                }
                SetExpr setExpr = (SetExpr)arg;
                ListTerm sequence = setExpr.getExpr();
                Iterator i = sequence.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (!(o instanceof TupleExpr)) {
                        String message = "Expected TupleExpr but got " + o;
                        throw new CannotPrintAstException(message);
                    }
                    TupleExpr tuple = (TupleExpr)o;
                    ListTerm tupleContents = tuple.getExpr();
                    if (tupleContents.size() != 2) {
                        String message = "Expected tuple of size 2 but was " + tupleContents.size();
                        throw new CannotPrintAstException(message);
                    }
                    result.add(this.visit((Expr)tupleContents.get(1)));
                    if (!i.hasNext()) continue;
                    result.add(ZString.COMMA);
                }
                ++pos;
                continue;
            }
            result.add(opPart);
        }
        return result;
    }

    public static class CannotPrintAstException
    extends RuntimeException {
        public CannotPrintAstException(String message) {
            super(message);
        }

        public CannotPrintAstException(Exception cause) {
            super(cause);
        }
    }
}

