/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.zpatt;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.parser.zpatt.LatexParser;
import net.sourceforge.czt.parser.zpatt.UnicodeParser;
import net.sourceforge.czt.session.Command;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.session.StringSource;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZSect;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static Term parse(Source source, SectionInfo sectInfo, Properties properties) throws ParseException, IOException {
        if (source.getMarkup() == Markup.LATEX) {
            LatexParser parser = new LatexParser(source.getReader(), source.toString(), sectInfo, properties);
            return parser.parse();
        }
        if (source.getMarkup() == Markup.UNICODE) {
            UnicodeParser parser = new UnicodeParser(source.getReader(), source.toString(), sectInfo, properties);
            return parser.parse();
        }
        throw new UnsupportedOperationException();
    }

    public static Term parse(Source source, SectionInfo sectInfo) throws ParseException, IOException {
        return ParseUtils.parse(source, sectInfo, new Properties());
    }

    public static Term parse(String filename, SectionInfo sectInfo) throws ParseException, FileNotFoundException {
        if (filename.endsWith(".tex") || filename.endsWith(".TEX")) {
            return ParseUtils.parseLatexFile(filename, sectInfo);
        }
        if (filename.endsWith(".utf8") || filename.endsWith(".UTF8")) {
            return ParseUtils.parseUtf8File(filename, sectInfo);
        }
        if (filename.endsWith(".utf16") || filename.endsWith(".UTF16")) {
            return ParseUtils.parseUtf16File(filename, sectInfo);
        }
        Logger logger = CztLogger.getLogger(ParseUtils.class);
        logger.warning("Cannot determine the file type of " + filename);
        return null;
    }

    public static Term parse(URL url, SectionInfo sectInfo) throws ParseException, IOException {
        String name = url.toString();
        if (name.endsWith(".tex") || name.endsWith(".TEX")) {
            return ParseUtils.parseLatexURL(url, sectInfo);
        }
        if (name.endsWith(".utf8") || name.endsWith(".UTF8")) {
            return ParseUtils.parseUtf8URL(url, sectInfo);
        }
        if (name.endsWith(".utf16") || name.endsWith(".UTF16")) {
            return ParseUtils.parseUtf16URL(url, sectInfo);
        }
        Logger logger = CztLogger.getLogger(ParseUtils.class);
        logger.warning("Cannot determine the file type of " + name);
        return null;
    }

    public static Term parseUtf8File(String filename, SectionInfo sectInfo) throws ParseException, FileNotFoundException {
        String encoding = "UTF-8";
        try {
            Logger logger = CztLogger.getLogger(ParseUtils.class);
            logger.fine("Parse utf8 file " + filename);
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
            UnicodeParser parser = new UnicodeParser(in, filename, sectInfo, new Properties());
            return parser.parse();
        }
        catch (UnsupportedEncodingException e) {
            String message = "This should not happen: Encoding UTF-8 not supported.";
            throw new CztException("This should not happen: Encoding UTF-8 not supported.", (Throwable)e);
        }
    }

    public static Term parseUtf8URL(URL url, SectionInfo sectInfo) throws ParseException, IOException {
        String encoding = "UTF-8";
        try {
            Logger logger = CztLogger.getLogger(ParseUtils.class);
            logger.fine("Parse utf8 file " + url.toString());
            InputStreamReader in = new InputStreamReader(url.openStream(), "UTF-8");
            UnicodeParser parser = new UnicodeParser(in, url.toString(), sectInfo, new Properties());
            return parser.parse();
        }
        catch (UnsupportedEncodingException e) {
            String message = "This should not happen: Encoding UTF-8 not supported.";
            throw new CztException("This should not happen: Encoding UTF-8 not supported.", (Throwable)e);
        }
    }

    public static Term parseUnicodeString(String input, SectionInfo sectInfo) throws ParseException, IOException {
        StringReader in = new StringReader(input);
        UnicodeParser parser = new UnicodeParser(in, "Standard input", sectInfo, new Properties());
        return parser.parse();
    }

    public static Term parseUtf16File(String filename, SectionInfo sectInfo) throws ParseException, FileNotFoundException {
        String encoding = "UTF-16";
        try {
            Logger logger = CztLogger.getLogger(ParseUtils.class);
            logger.fine("Parse utf16 file " + filename);
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-16");
            UnicodeParser parser = new UnicodeParser(in, filename, sectInfo, new Properties());
            return parser.parse();
        }
        catch (UnsupportedEncodingException e) {
            String message = "This should not happen: Encoding UTF-16 not supported.";
            throw new CztException("This should not happen: Encoding UTF-16 not supported.", (Throwable)e);
        }
    }

    public static Term parseUtf16URL(URL url, SectionInfo sectInfo) throws ParseException, IOException {
        String encoding = "UTF-16";
        try {
            Logger logger = CztLogger.getLogger(ParseUtils.class);
            logger.fine("Parse utf16 file " + url.toString());
            InputStreamReader in = new InputStreamReader(url.openStream(), "UTF-16");
            UnicodeParser parser = new UnicodeParser(in, url.toString(), sectInfo, new Properties());
            return parser.parse();
        }
        catch (UnsupportedEncodingException e) {
            String message = "This should not happen: Encoding UTF-16 not supported.";
            throw new CztException("This should not happen: Encoding UTF-16 not supported.", (Throwable)e);
        }
    }

    public static Term parseLatexFile(String filename, SectionInfo sectInfo) throws ParseException, FileNotFoundException {
        Logger logger = CztLogger.getLogger(ParseUtils.class);
        logger.fine("Parse LaTex file " + filename);
        InputStreamReader in = new InputStreamReader(new FileInputStream(filename));
        LatexParser parser = new LatexParser(in, filename, sectInfo, new Properties());
        return parser.parse();
    }

    public static Term parseLatexURL(URL url, SectionInfo sectInfo) throws ParseException, IOException {
        Logger logger = CztLogger.getLogger(ParseUtils.class);
        logger.fine("Parse LaTex file " + url.toString());
        InputStreamReader in = new InputStreamReader(url.openStream());
        LatexParser parser = new LatexParser(in, url.toString(), sectInfo, new Properties());
        return parser.parse();
    }

    public static Term parseLatexString(String input, SectionInfo sectInfo) throws ParseException {
        StringReader in = new StringReader(input);
        LatexParser parser = new LatexParser(in, "Standard input", sectInfo, new Properties());
        return parser.parse();
    }

    public static Pred parsePred(Source src, String section, SectionManager sectman) throws IOException, CommandException {
        AxPara axPara = null;
        String parent = section;
        String name = "CZT_parsePred_tmp1433589372849";
        StringBuffer buf = new StringBuffer();
        if (src.getMarkup() == Markup.LATEX) {
            if (parent == null) {
                parent = "standard\\_toolkit";
            }
            buf.append("\\begin{zsection}\\SECTION ");
            buf.append(name);
            buf.append(" \\parents ");
            buf.append(parent);
            buf.append("\\end{zsection} ");
            buf.append("\\begin{axdef} \\where\n");
            Reader reader = src.getReader();
            int ch = reader.read();
            while (ch != -1) {
                buf.appendCodePoint(ch);
                ch = reader.read();
            }
        } else {
            String message = "Unicode inputs not implemented yet";
            throw new UnsupportedOperationException(message);
        }
        buf.append("\n\\end{axdef}\n");
        SectionManager tmpsectman = (SectionManager)sectman.clone();
        StringSource input = new StringSource(buf.toString());
        input.setMarkup(src.getMarkup());
        input.setEncoding(src.getEncoding());
        tmpsectman.put(new Key(name, Source.class), input);
        Spec spec = (Spec)tmpsectman.get(new Key(name, Spec.class));
        ZSect sect = (ZSect)spec.getSect().get(0);
        for (Object p : sect.getPara()) {
            if (!(p instanceof AxPara)) continue;
            axPara = (AxPara)p;
            break;
        }
        assert (axPara != null);
        return axPara.getSchText().getPred();
    }

    public static Expr parseExpr(Source src, String section, SectionManager sectman) throws IOException, CommandException {
        AxPara axPara = null;
        String parent = section;
        String name = "CZT_parseExpr_tmp1433589372849";
        StringBuffer buf = new StringBuffer();
        if (src.getMarkup() == Markup.LATEX) {
            if (parent == null) {
                parent = "standard\\_toolkit";
            }
            buf.append("\\begin{zsection}\\SECTION ");
            buf.append(name);
            buf.append(" \\parents ");
            buf.append(parent);
            buf.append("\\end{zsection} ");
            buf.append("\\begin{axdef} result == \n");
            Reader reader = src.getReader();
            int ch = reader.read();
            while (ch != -1) {
                buf.appendCodePoint(ch);
                ch = reader.read();
            }
        } else {
            String message = "Unicode inputs not implemented yet";
            throw new UnsupportedOperationException(message);
        }
        buf.append("\n\\end{axdef}\n");
        SectionManager tmpsectman = (SectionManager)sectman.clone();
        StringSource input = new StringSource(buf.toString());
        input.setMarkup(src.getMarkup());
        input.setEncoding(src.getEncoding());
        tmpsectman.put(new Key(name, Source.class), input);
        Spec spec = (Spec)tmpsectman.get(new Key(name, Spec.class));
        ZSect sect = (ZSect)spec.getSect().get(0);
        for (Object p : sect.getPara()) {
            if (!(p instanceof AxPara)) continue;
            axPara = (AxPara)p;
            break;
        }
        ConstDecl cdecl = (ConstDecl)axPara.getSchText().getDecl().get(0);
        return cdecl.getExpr();
    }

    public static Markup getMarkup(String filename) {
        Markup result = null;
        if (filename.endsWith(".tex") || filename.endsWith(".TEX")) {
            result = Markup.LATEX;
        } else if (filename.endsWith(".utf8") || filename.endsWith(".UTF8") || filename.endsWith(".utf16") || filename.endsWith(".UTF16")) {
            result = Markup.UNICODE;
        }
        return result;
    }

    public static Command getCommand() {
        return new ParserCommand();
    }

    static class ParserCommand
    implements Command {
        ParserCommand() {
        }

        public boolean compute(String name, SectionManager manager) throws CommandException {
            try {
                Term term;
                Source source = (Source)manager.get(new Key(name, Source.class));
                if (source != null && (term = ParseUtils.parse(source, (SectionInfo)manager)) instanceof Spec) {
                    manager.put(new Key(name, Spec.class), (Spec)term);
                }
            }
            catch (ParseException exception) {
                throw new CommandException(exception);
            }
            catch (IOException exception) {
                throw new CommandException(exception);
            }
            return true;
        }
    }
}

