/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.zpatt;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.util.LatexMarkupParser;
import net.sourceforge.czt.parser.zpatt.Latex2Unicode;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.session.Source;

public class LatexToUnicode
implements Scanner {
    private LatexMarkupParser scanner_;
    private SectionInfo sectInfo_;
    private Latex2Unicode l2u_;

    public LatexToUnicode(URL url, SectionInfo sectInfo, Properties properties) throws IOException {
        this.l2u_ = new Latex2Unicode(url, properties);
        this.l2u_.setSource(url.toString());
        this.scanner_ = new LatexMarkupParser(this.l2u_, sectInfo);
        this.scanner_.setSource(url.toString());
    }

    public LatexToUnicode(Source source, SectionInfo sectInfo, Properties properties) throws IOException {
        this.l2u_ = new Latex2Unicode(source.getReader(), properties);
        this.l2u_.setSource(source.toString());
        this.scanner_ = new LatexMarkupParser(this.l2u_, sectInfo);
        this.scanner_.setSource(source.toString());
    }

    public LatexToUnicode(Reader in, SectionInfo sectInfo, Properties properties) {
        this.l2u_ = new Latex2Unicode(in, properties);
        this.scanner_ = new LatexMarkupParser(this.l2u_, sectInfo);
    }

    public LatexToUnicode(InputStream in, SectionInfo sectInfo, Properties properties) {
        this(new InputStreamReader(in), sectInfo, properties);
    }

    public void setSource(String source) {
        this.l2u_.setSource(source);
        this.scanner_.setSource(source);
    }

    public Symbol next_token() throws Exception {
        return this.scanner_.next_token();
    }

    public static void convert(URL url, String outfilename, Properties properties) throws Exception {
        InputStream input = url.openStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outfilename), "UTF-8");
        LatexToUnicode.convert(input, url.toString(), writer, properties);
        ((Writer)writer).close();
    }

    public static void convert(InputStream input, String source, Writer writer, Properties properties) throws Exception {
        LatexToUnicode scanner = new LatexToUnicode(input, (SectionInfo)new SectionManager(), properties);
        scanner.setSource(source);
        Symbol s = null;
        while (true) {
            s = scanner.next_token();
            if (s.sym == 0) break;
            if (s.value == null) continue;
            writer.write((String)s.value);
        }
    }

    public static void main(String[] args) {
        String usage = "Usage: java net.sourceforge.czt.parser.zpatt.LatexToUnicode [-in <inputfile>] [-out <outputfile>] [-encoding <encoding>]";
        try {
            String source = null;
            InputStream input = System.in;
            Writer writer = new PrintWriter(System.out);
            String outfile = null;
            String encoding = "UTF-8";
            for (int i = 0; i < args.length; ++i) {
                if ("-in".equals(args[i])) {
                    if (i < args.length) {
                        source = args[++i];
                        input = new FileInputStream(source);
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                if ("-encoding".equals(args[i])) {
                    if (i < args.length) {
                        encoding = args[++i];
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                if ("-out".equals(args[i])) {
                    if (i < args.length) {
                        outfile = args[++i];
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                System.err.println(usage);
                return;
            }
            if (outfile != null) {
                FileOutputStream stream = new FileOutputStream(outfile);
                writer = new OutputStreamWriter((OutputStream)stream, encoding);
            }
            LatexToUnicode.convert(input, source, writer, new Properties());
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

