/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.sourceforge.czt.parser.util.LocInfo;

public abstract class ParseError {
    private int line_;
    private int column_;
    private String source_;
    private String message_;
    private Object[] params_;

    public ParseError(String message, Object[] params, LocInfo locInfo) {
        this.message_ = message;
        this.params_ = params;
        this.setLocation(locInfo);
    }

    protected abstract String getResourceName();

    public int getLine() {
        return this.line_;
    }

    public void setLine(int line) {
        this.line_ = line;
    }

    public int getColumn() {
        return this.column_;
    }

    public void setColumn(int column) {
        this.column_ = column;
    }

    public String getSource() {
        return this.source_;
    }

    public void setSource(String source) {
        this.source_ = source;
    }

    public void setLocation(LocInfo locInfo) {
        if (locInfo == null) {
            return;
        }
        this.source_ = locInfo.getSource();
        this.line_ = locInfo.getLine() + 1;
        this.column_ = locInfo.getColumn() + 1;
    }

    public String getMessage() {
        String localized = ResourceBundle.getBundle(this.getResourceName()).getString(this.message_);
        MessageFormat form = new MessageFormat(localized);
        return form.format(this.params_);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.source_ != null) {
            result.append("\"" + this.source_ + "\"");
        }
        if (this.line_ >= 0) {
            result.append(" line " + this.line_);
        }
        if (this.column_ >= 0) {
            result.append(" column " + this.column_ + ": ");
        }
        return result.toString() + this.getMessage();
    }
}

