/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.ListTermVisitor;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.parser.util.LatexMarkupFunction;
import net.sourceforge.czt.parser.util.MarkupException;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Directive;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.visitor.LatexMarkupParaVisitor;
import net.sourceforge.czt.z.visitor.ParaVisitor;
import net.sourceforge.czt.z.visitor.ZSectVisitor;

public class LatexMarkupFunctionVisitor
implements TermVisitor,
LatexMarkupParaVisitor,
ListTermVisitor,
ParaVisitor,
ZSectVisitor {
    private LatexMarkupFunction table_;
    private SectionInfo sectInfo_;
    private Set dependencies_ = new HashSet();

    public LatexMarkupFunctionVisitor(SectionInfo sectInfo) {
        this.sectInfo_ = sectInfo;
    }

    public Class getInfoType() {
        return LatexMarkupFunction.class;
    }

    public Set getDependencies() {
        return this.dependencies_;
    }

    public Object run(ZSect sect) {
        sect.accept((Visitor)this);
        return this.getLatexMarkupFunction();
    }

    public List getRequiredInfoTypes() {
        ArrayList<Class<LatexMarkupFunction>> result = new ArrayList<Class<LatexMarkupFunction>>();
        result.add(LatexMarkupFunction.class);
        return result;
    }

    public LatexMarkupFunction getLatexMarkupFunction() {
        return this.table_;
    }

    public Object visitTerm(Term term) {
        String message = "LatexMarkupFunction can only be build for ZSects; was tried for " + term.getClass();
        throw new UnsupportedOperationException(message);
    }

    public Object visitListTerm(ListTerm listTerm) {
        for (Object o : listTerm) {
            if (!(o instanceof Term)) continue;
            Term t = (Term)o;
            this.visit(t);
        }
        return null;
    }

    public Object visitPara(Para para) {
        return null;
    }

    public Object visitLatexMarkupPara(LatexMarkupPara para) {
        ListTerm directives = para.getDirective();
        for (Directive directive : directives) {
            try {
                this.table_.add(directive);
            }
            catch (MarkupException e) {
                throw new CztException((Throwable)e);
            }
        }
        return null;
    }

    public Object visitZSect(ZSect zSect) {
        String name = zSect.getName();
        this.table_ = new LatexMarkupFunction(name);
        for (Parent parent : zSect.getParent()) {
            LatexMarkupFunction parentTable = (LatexMarkupFunction)this.get(parent.getWord(), LatexMarkupFunction.class);
            try {
                this.table_.add(parentTable);
            }
            catch (MarkupException e) {
                throw new CztException((Throwable)e);
            }
        }
        this.visit((Term)zSect.getPara());
        return null;
    }

    protected void visit(Term term) {
        term.accept((Visitor)this);
    }

    protected Object get(String name, Class type) {
        Key key = new Key(name, type);
        this.getDependencies().add(key);
        try {
            return this.sectInfo_.get(key);
        }
        catch (CommandException exception) {
            String message = "Cannot get " + type + " for " + name + "; try to continue anyway";
            CztLogger.getLogger(LatexMarkupFunctionVisitor.class).warning(message);
            return null;
        }
    }
}

