/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.parser.util.MarkupException;
import net.sourceforge.czt.z.ast.Directive;
import net.sourceforge.czt.z.ast.DirectiveType;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.util.Factory;

public class LatexMarkupFunction {
    private String section_;
    private Map commandToDirective_ = new HashMap();
    private Map unicodeToDirective_ = new HashMap();
    private List directives_ = new ArrayList();

    public LatexMarkupFunction(String section) {
        if (section == null) {
            String message = "A latex markup function must have a section name.";
            throw new NullPointerException("A latex markup function must have a section name.");
        }
        this.section_ = section;
    }

    public String getSection() {
        return this.section_;
    }

    public void add(Directive directive) throws MarkupException {
        String command = directive.getCommand();
        String unicode = directive.getUnicode();
        MarkupDirective markupDirective = new MarkupDirective(directive, this.section_);
        if (this.commandToDirective_.get(command) != null) {
            String message = "Command " + command + " defined twice in section " + this.section_;
            message = message + "\n" + this.commandToDirective_.get(command) + "\n" + markupDirective;
            throw new MarkupException(message);
        }
        this.commandToDirective_.put(command, markupDirective);
        this.unicodeToDirective_.put(unicode, markupDirective);
        this.directives_.add(markupDirective);
    }

    public void add(LatexMarkupFunction markupFunction) throws MarkupException {
        Collection toBeAdded = markupFunction.commandToDirective_.values();
        for (MarkupDirective directive : toBeAdded) {
            String command = directive.getCommand();
            if (this.getCommandDirective(command) != null) {
                this.checkDirectives(this.getCommandDirective(command), directive);
            } else {
                this.commandToDirective_.put(command, directive);
                this.unicodeToDirective_.put(directive.getUnicode(), directive);
            }
            assert (this.getCommandDirective(command) != null);
        }
    }

    public MarkupDirective getCommandDirective(String command) {
        return (MarkupDirective)this.commandToDirective_.get(command);
    }

    public MarkupDirective getUnicodeDirective(String unicode) {
        return (MarkupDirective)this.unicodeToDirective_.get(unicode);
    }

    private void checkDirectives(MarkupDirective directive1, MarkupDirective directive2) throws MarkupException {
        assert (directive1.getCommand().equals(directive2.getCommand()));
        if (!directive1.equals(directive2)) {
            String message = "Command " + directive1.getCommand() + " defined twice in section " + this.section_;
            message = message + "\n" + directive1 + "\n" + directive2;
            throw new MarkupException(message);
        }
    }

    public String toString() {
        return "LatexMarkupFunction for " + this.section_ + ": " + this.commandToDirective_.toString();
    }

    public LatexMarkupPara toAst(ZFactory factory) {
        LatexMarkupPara result = factory.createLatexMarkupPara();
        ListTerm directiveList = result.getDirective();
        for (MarkupDirective directive : this.directives_) {
            assert (directive.getSection().equals(this.section_));
            Directive newDirective = factory.createDirective(directive.getCommand(), directive.getUnicode(), directive.getType());
            if (directive.getLine() != null) {
                LocAnn locAnn = factory.createLocAnn();
                locAnn.setLine(directive.getLine());
                newDirective.getAnns().add((Object)locAnn);
            }
            directiveList.add(newDirective);
        }
        return result;
    }

    public LatexMarkupPara toAst(Factory factory) {
        LatexMarkupPara result = factory.createLatexMarkupPara();
        ListTerm directiveList = result.getDirective();
        for (MarkupDirective directive : this.directives_) {
            assert (directive.getSection().equals(this.section_));
            Directive newDirective = factory.createDirective(directive.getCommand(), directive.getUnicode(), directive.getType());
            if (directive.getLine() != null) {
                LocAnn locAnn = factory.createLocAnn();
                locAnn.setLine(directive.getLine());
                newDirective.getAnns().add((Object)locAnn);
            }
            directiveList.add(newDirective);
        }
        return result;
    }

    public Iterator iterator() {
        return this.commandToDirective_.values().iterator();
    }

    public static class MarkupDirective {
        private String command_;
        private String unicode_;
        private DirectiveType type_;
        private String section_;
        private Integer lineNr_ = null;

        public MarkupDirective(String command, String unicode, DirectiveType type, String section, Integer lineNr) {
            this.command_ = command;
            this.unicode_ = unicode;
            this.type_ = type;
            this.section_ = section;
            this.lineNr_ = lineNr;
            this.checkMembersNonNull();
        }

        public MarkupDirective(Directive directive, String section) {
            this.command_ = directive.getCommand();
            this.unicode_ = directive.getUnicode();
            this.type_ = directive.getType();
            this.section_ = section;
            for (Object o : directive.getAnns()) {
                if (!(o instanceof LocAnn)) continue;
                LocAnn locAnn = (LocAnn)o;
                this.lineNr_ = locAnn.getLine();
            }
            this.checkMembersNonNull();
        }

        private void checkMembersNonNull() {
            if (this.command_ == null || this.unicode_ == null || this.type_ == null || this.section_ == null) {
                throw new NullPointerException();
            }
        }

        public Integer getLine() {
            return this.lineNr_;
        }

        public String getSection() {
            return this.section_;
        }

        public String getCommand() {
            return this.command_;
        }

        public String getUnicode() {
            return this.unicode_;
        }

        public DirectiveType getType() {
            return this.type_;
        }

        public boolean addLeftSpace() {
            DirectiveType in = DirectiveType.IN;
            DirectiveType post = DirectiveType.POST;
            return this.getType().equals((Object)in) || this.getType().equals((Object)post);
        }

        public boolean addRightSpace() {
            DirectiveType in = DirectiveType.IN;
            DirectiveType pre = DirectiveType.PRE;
            return this.getType().equals((Object)in) || this.getType().equals((Object)pre);
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass().equals(obj.getClass())) {
                MarkupDirective directive = (MarkupDirective)obj;
                if (!this.command_.equals(directive.command_)) {
                    return false;
                }
                if (!this.unicode_.equals(directive.unicode_)) {
                    return false;
                }
                if (!this.type_.equals((Object)directive.type_)) {
                    return false;
                }
                return this.section_.equals(directive.section_);
            }
            return false;
        }

        public String toString() {
            String result = this.command_ + "(" + this.type_ + ") --> " + this.unicode_ + " defined in " + this.section_;
            return result;
        }
    }
}

