/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.czt.z.ast.Expr;

public class DefinitionTable {
    private String section_;
    private SortedMap definitions_ = new TreeMap();

    public DefinitionTable(String section, Collection parents) throws DefinitionException {
        this.section_ = section;
        if (parents != null) {
            for (DefinitionTable table : parents) {
                this.addParentDefinitionTable(table);
            }
        }
    }

    private void addParentDefinitionTable(DefinitionTable parentTable) throws DefinitionException {
        this.definitions_.putAll(parentTable.definitions_);
    }

    public String getSection() {
        return this.section_;
    }

    public Definition lookup(String defname) {
        return (Definition)this.definitions_.get(defname);
    }

    public String toString() {
        return "DefinitionTable for " + this.section_ + "\n" + this.definitions_;
    }

    public void add(String defName, Definition def) throws DefinitionException {
        this.definitions_.put(defName, def);
    }

    public static class Definition {
        private List genericParams_;
        private Expr definition_;

        public Definition(List generic, Expr definition) {
            this.genericParams_ = generic;
            this.definition_ = definition;
        }

        public List getDeclNames() {
            return this.genericParams_;
        }

        public Expr getExpr() {
            return this.definition_;
        }

        public String toString() {
            return this.genericParams_.toString() + " " + this.definition_.toString();
        }
    }

    public class DefinitionException
    extends Exception {
        public DefinitionException(String message) {
            super(message);
        }
    }
}

