/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;

public class CztReader
extends Reader {
    private Scanner scanner_;
    private String buffer_ = "";
    private int charNum_ = 0;
    private TreeMap lineMap_ = new TreeMap();
    private TreeMap columnMap_ = new TreeMap();

    public CztReader(Scanner scanner) {
        this.scanner_ = scanner;
    }

    public CztReader(Scanner scanner, Object lock) {
        super(lock);
        this.scanner_ = scanner;
    }

    public void close() {
    }

    public int read(char[] cbuf, int off, int len) {
        if (this.buffer_ == null) {
            return -1;
        }
        while (this.buffer_.length() < len) {
            Symbol s = null;
            try {
                s = this.scanner_.next_token();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (s == null) continue;
            if (s.sym == 0) {
                if (this.buffer_.length() == 0) {
                    return -1;
                }
                for (int i = 0; i < this.buffer_.length(); ++i) {
                    cbuf[off + i] = this.buffer_.charAt(i);
                }
                int result = this.buffer_.length();
                this.buffer_ = null;
                return result;
            }
            if (s.value == null) continue;
            this.buffer_ = this.buffer_ + s.value;
            this.lineMap_.put(new Integer(this.charNum_), new Integer(s.left));
            this.columnMap_.put(new Integer(this.charNum_), new Integer(s.right));
            this.charNum_ += ((String)s.value).length();
        }
        for (int i = 0; i < len; ++i) {
            cbuf[off + i] = this.buffer_.charAt(i);
        }
        this.buffer_ = this.buffer_.substring(len);
        return len;
    }

    public int getLine(int charNum) {
        Integer iCharNum = new Integer(charNum);
        Integer result = (Integer)this.lineMap_.get(iCharNum);
        if (result == null) {
            SortedMap map = this.lineMap_.headMap(new Integer(charNum));
            try {
                Integer lastKey = map.lastKey();
                result = (Integer)map.get(lastKey);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
        }
        return result;
    }

    public int getColumn(int charNum) {
        Integer iCharNum = new Integer(charNum);
        Integer result = (Integer)this.columnMap_.get(iCharNum);
        if (result == null) {
            SortedMap map = this.columnMap_.headMap(new Integer(charNum));
            try {
                Integer lastKey = map.lastKey();
                result = (Integer)map.get(lastKey);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
        }
        return result;
    }
}

