/*
 * Decompiled with CFR 0.152.
 */
package circparser;

import circparser.grammar.ClassifyTokens;
import circparser.grammar.FailParserException;
import circparser.grammar.parser;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java_cup.runtime.Symbol;
import net.sourceforge.czt.z.ast.Spec;

public class CircusParser {
    private static Map<String, List<String>> errors = new TreeMap<String, List<String>>();

    public static Spec parse(String path) throws Exception {
        FileInputStream instream = null;
        parser parser_obj = new parser(path);
        errors.put(path, parser_obj.getErrors());
        Spec prog = null;
        Symbol parse_tree = null;
        instream = new FileInputStream(path);
        ClassifyTokens yl = new ClassifyTokens(instream);
        parser_obj.assignLex(yl);
        yl.getLexer().sourceFilename = path;
        parse_tree = parser_obj.parse();
        prog = (Spec)parse_tree.value;
        return prog;
    }

    public static void testFile(String path) {
        try {
            CircusParser.parse(path);
            errors.remove(path);
        }
        catch (FailParserException fpe) {
            System.out.println(fpe.getMessage());
        }
        catch (Exception e) {
            System.out.println(path + " - Exception: " + e.getMessage() + "\n");
            e.printStackTrace();
        }
    }

    public static void completeTest() {
        String testDir = "D:\\research\\tools\\circus\\CircusParser\\tests\\";
        CircusParser.testFile(testDir + "ConcreteFibonnaci.tex");
        CircusParser.testFile(testDir + "Processo.tex");
        CircusParser.testFile(testDir + "T_Simple.tex");
        CircusParser.testFile(testDir + "cliente_servidorLoja.zed");
        CircusParser.testFile(testDir + "ex1.circ");
        CircusParser.testFile(testDir + "generic.tex");
        CircusParser.testFile(testDir + "paper.tex");
        CircusParser.testFile(testDir + "processo1.tex");
        CircusParser.testFile(testDir + "processo2.tex");
        CircusParser.testFile(testDir + "schema.tex");
        CircusParser.testFile(testDir + "wp1.tex");
    }

    public static void singleTest(String path) {
        try {
            System.out.println("Parsing: " + path);
            Spec spec = CircusParser.parse(path);
            System.out.println("Parser OK!");
        }
        catch (Exception e) {
            System.out.println(path + " - Exception: " + e.getMessage() + "\n");
            e.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            CircusParser.singleTest(args[0]);
        } else {
            CircusParser.completeTest();
        }
        if (errors.isEmpty()) {
            System.out.println("No errors, good!");
        } else {
            System.err.println(errors.size() + " error(s) in total, bad!");
            for (String s : errors.keySet()) {
                System.err.println("Error(s) for " + s.substring(s.lastIndexOf(92) + 1));
                for (String e : errors.get(s)) {
                    System.err.println("\t" + e);
                }
            }
        }
    }
}

