/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.czt.util.CztException;

public final class Delegator
implements InvocationHandler {
    private Map map_ = new HashMap();

    private Delegator(Class[] interfaces, Object[] impls) {
        if (interfaces == null || impls == null) {
            throw new NullPointerException();
        }
        if (interfaces.length != impls.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] == null || impls[i] == null) {
                throw new NullPointerException();
            }
            if (!interfaces[i].isAssignableFrom(impls[i].getClass())) {
                throw new IllegalArgumentException(impls[i].getClass().toString() + " is not an instance of " + interfaces[i].toString());
            }
            Method[] methods = interfaces[i].getMethods();
            for (int j = 0; j < methods.length; ++j) {
                String methodName = methods[j].getName();
                if (this.map_.get(methodName) != null && this.map_.get(methodName) != impls[i]) {
                    String message = methodName + " is defined in more than one interface.";
                    throw new IllegalArgumentException(message);
                }
                this.map_.put(methodName, impls[i]);
            }
        }
    }

    public static Object newInstance(Class[] interfaces, Object[] implementations) {
        ClassLoader classLoader = null;
        if (interfaces.length > 0) {
            classLoader = interfaces[0].getClassLoader();
        }
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new Delegator(interfaces, implementations));
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object impl = this.map_.get(m.getName());
        if (impl != null) {
            return m.invoke(impl, args);
        }
        throw new CztException("Delegator: unexpected method dispatched: " + m);
    }
}

