import jcsp.lang.*;

class CallChef implements CSProcess {
  
  //{{{  COMMENT documentation
  //
  //The Chef is an active object.  He/she cooks chickens in batches of four --
  //taking around 2 seconds per batch -- and then sends them to the Canteen.
  //The Chef is delayed in the Canteen, waiting for an acknowledge that the
  //batch has been set down OK.
  //
  //This cycle continues indefinitely.
  //
  //}}}
  
  private final String id;
  private final int batchSize;
  private final int batchTime;
  private final CallCanteen.Supply supply;
  
  public CallChef (String id, int batchSize, int batchTime, CallCanteen.Supply supply) {
    this.id = id;
    this.batchSize = batchSize;
    this.batchTime = batchTime;
    this.supply = supply;
  }
  
  public void run () {

    final CSTimer tim = new CSTimer ();

    int nReturned = 0;
    int nSupplied = 0;
      
    while (true) {
      // cook batchSize chickens
      System.out.println ("   Chef " + id + " : cooking ... " + (batchSize - nReturned) + " chickens");
      tim.sleep (batchTime);                    // this takes batchTime milliseconds to cook
      System.out.println ("   Chef " + id + " : " + batchSize + " chickens, ready-to-go ... ");
      nReturned = supply.freshChickens (id, batchSize);    // supply the chickens and wait till set down
      nSupplied += (batchSize - nReturned);
      System.out.println ("   Chef " + id + " : " + nReturned + " returned [" + nSupplied + " supplied]");
    }
  }
  
}
