import jcsp.lang.*;
import jcsp.awt.*;

import java.awt.*;

class FrameZapper implements CSProcess {

  private final Frame frame;
  private final ChannelInputInt destroy;
  private final ChannelOutputInt destroyAck;

  public FrameZapper (final Frame frame,
                      final ChannelInputInt destroy,
                      final ChannelOutputInt destroyAck) {
    this.frame = frame;
    this.destroy = destroy;
    this.destroyAck = destroyAck;
  }

  public void run () {

    destroy.read ();
    System.out.println ("FrameZapper: destroy.read () ... zapping frame ...");

    // Test cheat for continued operation of detached frame (Sun's Java Plug-in)
    // Timer tim = new Timer ();
    // for (int i = 45; i >= 0; i--) {
    //   tim.after (tim.read () + 1000);
    //   System.out.println ("FrameZapper: counting ... " + i);
    //  }

    frame.setVisible (false);
    frame.dispose ();
    System.out.println ("FrameZapper: frame zapped ... acknowledging destroy ...");
    destroyAck.write (0);

  }

}
