import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

import java.awt.*;
import java.awt.image.*;

class PlasmaNetwork implements CSProcess {

  private final ActiveCanvas activeCanvas;
  private final PlasmaControl plasmaControl;
  private final ActiveChoice scaleChoice;
  private final ActiveChoice colourChoice;
  private final ActiveTextField codeTextField;
  private final ActiveButton freezeButton;
  private final ActiveLabel fpsLabel;

  public PlasmaNetwork (final Container parent) {

    // channels

    // final One2OneChannel mouseChannel =
    //   One2OneChannel.create (new OverWriteOldestBuffer (10));
    // final One2OneChannel mouseMotionChannel =
    //   One2OneChannel.create (new OverWriteOldestBuffer (1));
    // final One2OneChannel keyChannel =
    //   One2OneChannel.create (new OverWriteOldestBuffer (10));

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    // processes

    parent.setLayout (new BorderLayout ());
    parent.setBackground (Color.black);

    activeCanvas = new ActiveCanvas ();
    // activeCanvas.addMouseEventChannel (mouseChannel);
    // activeCanvas.addMouseMotionEventChannel (mouseMotionChannel);
    // activeCanvas.addKeyEventChannel (keyChannel);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    parent.add ("Center", activeCanvas);

    // south panel

    final Panel south = new Panel ();
    south.setBackground (Color.green);

    final One2OneChannel codeChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel codeConfigure = new One2OneChannel ();
    codeTextField = new ActiveTextField (codeConfigure, codeChannel, "XXXXXXXXXXXXXX", 24);
    codeTextField.setBackground (Color.white);
    codeTextField.setEnabled (true);
    south.add (new Label ("Genetic Code", Label.CENTER));
    south.add (codeTextField);

    final One2OneChannel scaleChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel scaleConfigure = new One2OneChannel ();
    scaleChoice = new ActiveChoice (scaleConfigure, scaleChannel);
    final String[] scaleMenu = {"1:1", "1:2", "1:4", "1:8", "1:16"};
    for (int i = 0; i < scaleMenu.length; i++) {
      scaleChoice.add (scaleMenu[i]);
    }
    south.add (new Label ("Scale", Label.CENTER));
    south.add (scaleChoice);

    final One2OneChannel colourChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel colourConfigure = new One2OneChannel ();
    colourChoice = new ActiveChoice (colourConfigure, colourChannel);
    final String[] colourMenu = {"Red/Green/Blue", "Red/Blue", "Red/Green", "Green/Blue", "Jumpy"};
    for (int i = 0; i < colourMenu.length; i++) {
      colourChoice.add (colourMenu[i]);
    }
    south.add (new Label ("Colours", Label.CENTER));
    south.add (colourChoice);

    parent.add ("South", south);

    // north panel

    final Panel north = new Panel ();
    north.setBackground (Color.green);

    final One2OneChannel freezeChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel freezeConfigure = new One2OneChannel ();
    freezeButton = new ActiveButton (freezeConfigure, freezeChannel, "XXXXXXXXXXXXXX");
    freezeButton.setBackground (Color.white);
    freezeButton.setEnabled (true);
    north.add (freezeButton);

    final One2OneChannel fpsConfigure = new One2OneChannel ();
    fpsLabel = new ActiveLabel (fpsConfigure, "XXXXXXXXXXXXXX");
    fpsLabel.setAlignment (Label.CENTER);
    fpsLabel.setBackground (Color.white);
    north.add (new Label ("Frames/Second", Label.CENTER));
    north.add (fpsLabel);

    parent.add ("North", north);

    plasmaControl=
      new PlasmaControl (// mouseChannel, mouseMotionChannel, keyChannel,
                         codeConfigure, codeChannel,
                         colourConfigure, colourChannel, colourMenu,
                         scaleConfigure, scaleChannel, scaleMenu,
                         freezeConfigure, freezeChannel,
                         fpsConfigure,
                         toGraphics, fromGraphics);

  }

  public void run () {

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        plasmaControl,
        codeTextField,
        scaleChoice,
        colourChoice,
        freezeButton,
        fpsLabel
      }
    ).run ();

  }

}
