import jcsp.lang.*;

class Security implements CSProcess {

  // protected attributes

  protected AltingChannelInput down, up;
  protected ChannelOutput report;

  protected static final int maxSitting = 4;

  protected SecurityReport[] seated = new SecurityReport[maxSitting + 1];

  // constructors

  public Security (AltingChannelInput down, AltingChannelInput up,
                   ChannelOutput report) {
    this.down = down;
    this.up = up;
    this.report = report;
    for (int i = 0; i < (maxSitting + 1); i++) {
      seated[i] = new SecurityReport (i);
    }
  }

  // public methods

  public void run () {

    Alternative alt = new Alternative (new Guard[] {down, up});
    boolean[] precondition = {true, true};
    final int DOWN = 0;
    final int UP = 1;

    int nSitting = 0;

    int philId;

    while (true) {
      precondition[DOWN] = (nSitting < maxSitting);
      switch (alt.fairSelect (precondition)) {
        case DOWN:
          philId = ((Integer) down.read ()).intValue();
          nSitting++;
          report.write (seated[nSitting]);
        break;
        case UP:
          philId = ((Integer) up.read ()).intValue();
          nSitting--;
          report.write (seated[nSitting]);
        break;
      }
    }
  }

}
