import jcsp.lang.*;

class Fork implements CSProcess {

  // protected attributes

  protected int id;
  protected Integer Id;
  protected AltingChannelInput left, right;
  protected ChannelOutput report;

  protected ForkReport leftUp, leftDown, rightUp, rightDown;

  // constructors

  public Fork (int nPhilosophers, int id,
               AltingChannelInput left, AltingChannelInput right,
               ChannelOutput report) {
    this.id = id;
    Id = new Integer(id);
    this.left = left;
    this.right = right;
    this.report = report;
    leftUp = new ForkReport (id, id, ForkReport.UP);
    leftDown = new ForkReport (id, id, ForkReport.DOWN);
    rightUp = new ForkReport ((id + 1) % nPhilosophers, id, ForkReport.UP);
    rightDown = new ForkReport ((id + 1) % nPhilosophers, id, ForkReport.DOWN);
  }

  // public methods

  public void run () {
    Alternative alt = new Alternative (new Guard[] {left, right});
    final int LEFT = 0;
    final int RIGHT = 1;
    int philId;
    while (true) {
      switch (alt.fairSelect ()) {
        case LEFT:
          philId = ((Integer) left.read ()).intValue();
          report.write (leftUp);
          philId = ((Integer) left.read ()).intValue();
          report.write (leftDown);
        break;
        case RIGHT:
          philId = ((Integer) right.read ()).intValue();
          report.write (rightUp);
          philId = ((Integer) right.read ()).intValue();
          report.write (rightDown);
        break;
      }
    }
  }

}
