import jcsp.lang.*;

class MandelWorker implements CSProcess {

  private final int id;

  private final int minMaxIterations;
  private final int maxMaxIterations;

  private final ChannelInput fromFarmer;
  private final ChannelOutput toFarmer;

  private final ChannelInput fromHarvester;
  private final ChannelOutput toHarvester;

  public MandelWorker (final int id,
                       final int minMaxIterations,
                       final int maxMaxIterations,
                       final ChannelInput fromFarmer,
                       final ChannelOutput toFarmer,
                       final ChannelInput fromHarvester,
                       final ChannelOutput toHarvester) {
    this.id = id;
    this.minMaxIterations = minMaxIterations;
    this.maxMaxIterations = maxMaxIterations;
    this.fromFarmer = fromFarmer;
    this.toFarmer = toFarmer;
    this.fromHarvester = fromHarvester;
    this.toHarvester = toHarvester;
  }

  public void run () {

    final int radius = 2;

    final MandelPoint mandel = new MandelPoint (0, radius);

    WorkPacket work = new WorkPacket ();
    ResultPacket result = new ResultPacket ();

    int count = 0;

    System.out.println ("Worker " + id + " priority = " + PriParallel.getPriority ());
    PriParallel.setPriority (Thread.MIN_PRIORITY);
    System.out.println ("Worker " + id + " priority = " + PriParallel.getPriority ());

    toFarmer.write (work);
    work = (WorkPacket) fromFarmer.read ();

    final int nPoints = work.X.length;
    result.points = new byte[nPoints];

    while (true) {
      count++;
      if ((count % 100) == 0) System.out.println ("Worker " + id + " working ... " + count );
      mandel.setMaxIterations (work.maxIterations);
      for (int i = 0; i < nPoints; i++) {
        final int iterations = mandel.compute (work.X[i], work.y);
        if ((iterations == work.maxIterations) || (iterations == 0)) {
          result.points[i] = 0;
        } else {
          final byte biterations = (byte) iterations;
          if (biterations == 0) {
            result.points[i] = 1;  // OK for smooth colouring (rough ==> 127 ???)
          } else {
            result.points[i] = biterations;
          }
        }
      }
      result.j = work.j;
      toHarvester.write (result);  // these communication-pairs could be in PAR
      fromHarvester.read ();
      toFarmer.write (work);
      work = (WorkPacket) fromFarmer.read ();
      Thread.yield ();
    }

  }

}
