import jcsp.lang.*;
import jcsp.plugNplay.ints.*;

public class SeqSwitch2 implements CSProcess {

  private final ChannelInputInt in0;
  private final ChannelInputInt in1;
  private final ChannelOutputInt out0;
  private final ChannelOutputInt out1;

 
  public SeqSwitch2 (ChannelInputInt in0, ChannelInputInt in1,
                     ChannelOutputInt out0, ChannelOutputInt out1) {
    this.in0 = in0;
    this.in1 = in1;
    this.out0 = out0;
    this.out1 = out1;
  }
 
  public void run () {

    ProcessReadInt[] inProcs =
      {new ProcessReadInt (in0), new ProcessReadInt (in1)};
    ProcessWriteInt[] outProcs =
      {new ProcessWriteInt (out0), new ProcessWriteInt (out1)};

    Sequence inSeq = new Sequence (inProcs);
    Sequence outSeq = new Sequence (outProcs);

    while (true) {

      inSeq.run ();     // read from channel in0 then in1

      outProcs[0].value = inProcs[1].value;
      outProcs[1].value = inProcs[0].value;

      outSeq.run ();    // write to channel out0 then out1

    }

  }
 
}
