import jcsp.lang.*;
import jcsp.util.*;
import jcsp.plugNplay.*;

class RegulateTest {

  public static void main (String[] args) {

    final One2OneChannel a = new One2OneChannel ();
    final One2OneChannel b = new One2OneChannel ();
    final One2OneChannel c = new One2OneChannel ();
    final One2OneChannel reset = One2OneChannel.create (new OverWriteOldestBuffer (1));

    new Parallel (
      new CSProcess[] {
        new Numbers (a),                   // generate numbers
        new FixedDelay (250, a, b),        // let them through every quarter second
        new Regulate (b, reset, c, 1000),  // initially sample every second
        new CSProcess () {
          public void run () {
            Long[] sample = {new Long (1000), new Long (250), new Long (100)};
            int[] count = {10, 40, 100};
            while (true) {
              for (int cycle = 0; cycle < sample.length; cycle++) {
                reset.write (sample[cycle]);
                System.out.println ("\nSampling every " + sample[cycle] + " ms ...\n");
                for (int i = 0; i < count[cycle]; i++) {
                  Integer n = (Integer) c.read ();
                  System.out.println ("\t==> " + n);
                }
              }
            }
          }
        }
      }
    ).run ();
  }

}
