import jcsp.lang.*;

public class BarrierExample2 {

  public static void main (String[] args) {

    final int nWorkers = 10;
    final int rogue = 5;

    final int second = 1000;                // JCSP timer units are milliseconds
    final int tick = 1*second;
    final int maxWork = tick;               // raise this to allow workers to overrun

    final long seed = new CSTimer ().read ();

    final Barrier barrier = new Barrier (1);

    final TimeKeeper timeKeeper = new TimeKeeper (tick, barrier);

    final Worker[] workers = new Worker[nWorkers];
    for (int i = 0; i < workers.length; i++) {
      workers[i] = new Worker (i, i + seed, maxWork, i == rogue, barrier);
    }

    new Parallel (
      new CSProcess[] {
        timeKeeper,
        new Parallel (workers)
      }
    ).run ();

  }

}
