import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveWindowExample {

  public static void main (String argv[]) {

    final Frame root = new Frame ("ActiveWindow Example");

    final Channel event =
      One2OneChannel.create (new OverWriteOldestBuffer (10));

    final ActiveWindow window = new ActiveWindow (null, event, root);

    root.setSize (400, 400);
    root.setVisible (true);
    window.setVisible (true);

    new Parallel (
      new CSProcess[] {
        window,
        new CSProcess () {
          public void run () {
            while (true) {
              WindowEvent w = (WindowEvent) event.read ();
              System.out.println (w);
            }
          }
        }
      }
    ).run ();
  }

}
