import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.ints.*;
import jcsp.awt.*;

public class ActiveScrollbarExample {

  public static void main (String argv[]) {

    final Frame root = new Frame ("ActiveScrollbar Example");

    final One2OneChannelInt scrollEvent =
      One2OneChannelInt.create (new OverWriteOldestBufferInt (10));

    final ActiveScrollbar scrollBar =
      new ActiveScrollbar (null, scrollEvent,
                           Scrollbar.HORIZONTAL, 0, 10, 0, 110);

    root.setSize (400, 75);
    root.add (scrollBar);
    root.setVisible (true);

    new Parallel (
      new CSProcess[] {
        scrollBar,
        new CSProcess () {
          public void run () {
            final long FREE_TIME = 10000;
            final long BUSY_TIME = 1000;
            CSTimer tim = new CSTimer ();
            Alternative alt = new Alternative (new Guard[] {tim, scrollEvent});
            long timeout = tim.read ();
            tim.setAlarm (timeout + FREE_TIME);
            boolean running = true;
            while (running) {
              switch (alt.priSelect ()) {
                case 0:  // timeout happened
                  for (int i = 10; i > 0; i--) {
                    System.out.println ("*** busy busy busy ... " + i);
                    timeout = tim.read ();
                    tim.after (timeout + BUSY_TIME);
                  }
                  System.out.println ("*** free free free ... 0");
                  timeout = tim.read ();
                  tim.setAlarm (timeout + FREE_TIME);
                break;
                case 1:  // scrollEvent happened
                  int position = scrollEvent.read ();
                  System.out.println ("ScrollBar ==> " + position);
                  running = (position != 100);
                break;
              }
            }
            root.setVisible (false);
            System.exit (0);
          }
        }
      }
    ).run ();
  }

}
