import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveDialogExample {

  public static void main (String argv[]) {

    final Frame root = new Frame ("ActiveDialog Example");

    final Channel event =
      One2OneChannel.create (new OverWriteOldestBuffer (10));

    final ActiveDialog dialog = new ActiveDialog (null, event, root);

    root.setSize (400, 400);
    root.setVisible (true);
    dialog.setVisible (true);

    new Parallel (
      new CSProcess[] {
        dialog,
        new CSProcess () {
          public void run () {
            while (true) {
              WindowEvent w = (WindowEvent) event.read ();
              System.out.println (w);
            }
          }
        }
      }
    ).run ();
  }

}
