import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveCheckboxMenuItemExample2 {

  public static void main (String argv[]) {

    final ActiveClosingFrame activeClosingFrame =
      new ActiveClosingFrame ("ActiveCheckboxMenuItem Example");

    final ActiveFrame frame = activeClosingFrame.getActiveFrame ();

    final MenuBar menuBar = new MenuBar ();
    frame.setMenuBar (menuBar);

    final Menu fileMenu = new Menu ("File");
    final Menu langMenu = new Menu ("Language");
    menuBar.add (fileMenu);
    menuBar.add (langMenu);

    final String[] fileOptions = {"Hello World", "Rocket Science", "CSP",
                                  "Monitors", "Ignore Me", "Goodbye World"};
    final String[] langOptions = {"occam", "Java", "Smalltalk", "Algol-60",
                                  "Pascal", "Haskell", "SML", "Lisp"};

    final Channel event[] =
      Any2OneChannel.create (2, new OverWriteOldestBuffer (10));

    final ActiveCheckboxMenuItem[] fileMenuItem =
      new ActiveCheckboxMenuItem[fileOptions.length];
    for (int i = 0; i < fileOptions.length; i++) {
      fileMenuItem[i] = new ActiveCheckboxMenuItem (null, event[0], fileOptions[i]);
      fileMenu.add (fileMenuItem[i]);
    }

    final One2OneChannel[] checkConfigure = One2OneChannel.create (langOptions.length);
    final ActiveCheckboxMenuItem[] langCheckboxMenuItem =
      new ActiveCheckboxMenuItem[langOptions.length];
    for (int i = 0; i < langOptions.length; i++) {
      langCheckboxMenuItem[i] =
        new ActiveCheckboxMenuItem (checkConfigure[i], event[1], langOptions[i]);
      langMenu.add (langCheckboxMenuItem[i]);
    }

    final int initialLang = 0;
    langCheckboxMenuItem[initialLang].setState (true);   // initially selected language

    frame.setSize (300, 200);
    frame.setBackground (Color.green);
    frame.setVisible (true);

    new Parallel (
      new CSProcess[] {
        activeClosingFrame,
        new Parallel (fileMenuItem),
        new Parallel (langCheckboxMenuItem),
        new CSProcess () {
          public void run () {
            boolean running = true;
            while (running) {
              final ItemEvent e = (ItemEvent) event[0].read ();
              final String item = (String) e.getItem ();
              System.out.print ("File ==> `" + item);
              if (e.getStateChange () == ItemEvent.SELECTED) {
                System.out.println ("' selected ...");
              } else {
                System.out.println ("' deselected ...");
              }
              running = (item != fileOptions[fileOptions.length - 1]);
            }
            frame.setVisible (false);
            System.exit (0);
          }
        },
        new CSProcess () {
          public void run () {
            final Character SELECT = new Character ('S');
            final Character DESELECT = new Character ('s');
            int chosen = initialLang;
            while (true) {
              final ItemEvent e = (ItemEvent) event[1].read ();
              final String item = (String) e.getItem ();
              System.out.println ("Language ==> `" + item + "' selected ...");
              int selected = 0;
              while (item != langOptions[selected]) selected++;   // search will succeed
              checkConfigure[chosen].write (DESELECT);
              chosen = selected;
              checkConfigure[chosen].write (SELECT);
            }
          }
        }
      }
    ).run ();

  }

}
