import jcsp.lang.*;
import jcsp.util.ints.*;
import jcsp.plugNplay.ints.*;

public final class PrimeMultiples implements CSProcess {

  private final int[] primes;

  public PrimeMultiples (final int[] primes) {
    // assume these are distinct primes
    this.primes = primes;
  }

  public void run () {

    final int n = primes.length;

    final One2OneChannelInt[] a = One2OneChannelInt.create (n + 1);
    final One2OneChannelInt[] b = One2OneChannelInt.create (n,
                                    new InfiniteBufferInt ());
    final One2OneChannelInt c = new One2OneChannelInt ();
    final One2OneChannelInt d = new One2OneChannelInt ();

    final CSProcess[] Multipliers = new CSProcess[n];
    for (int i = 0; i < n; i++) {
      Multipliers[i] = new MultInt (primes[i], a[i], b[i]);
    }

    new Parallel (
      new CSProcess[] {
        new Parallel (Multipliers),
        new MergeInt (b, c),
        new PrefixInt (1, c, d),
        new DeltaInt (d, a),
        new PrinterInt (a[n], "--> ", "\n")
      }
    ).run ();
  }
}
