import jcsp.lang.*;

class Sieve implements CSProcess {

  //{{{ private in, out
  private final ChannelInputInt in;
  private final ChannelOutputInt out;
  //}}} 
  
  //{{{ public Sieve
  public Sieve (final ChannelInputInt in, final ChannelOutputInt out) {
    this.in = in;
    this.out = out;
  }
  //}}} 
  
  //{{{ public void run
  public void run () {
    int n = in.read ();
    out.write (n);
    One2OneChannelInt c = new One2OneChannelInt ();
    new Parallel (
      new CSProcess[] {
        new NoMultiples (n, in, c),
        new Sieve (c, out)
      }
    ).run ();
  }
  //}}} 

}
