import jcsp.lang.*;

class NumbersFrom implements CSProcess {

  //{{{ private start, increment, out
  private final int start;
  private final int increment;
  private final ChannelOutputInt out;
  //}}} 
  
  //{{{ public NumbersFrom
  public NumbersFrom (final int start,
                      final int increment,
                      final ChannelOutputInt out) {
    this.start = start;
    this.increment = increment;
    this.out = out;
  }
  //}}} 
  
  //{{{ public void run
  public void run () {
    int n = start;
    while (true) {
      out.write (n);
      n += increment;
    }
  }
  //}}} 

}
