import jcsp.lang.*;

public class BucketExample2 {

  public static void main (String[] args) {

    final int minDingbat = 2;
    final int maxDingbat = 10;
    final int nDingbats = (maxDingbat - minDingbat) + 1;

    final int nBuckets = 2*maxDingbat;

    final Bucket[] bucket = Bucket.create (nBuckets);

    final int second = 1000;     // JCSP timer units are milliseconds
    final int tick = second;
    final BucketKeeper bucketKeeper = new BucketKeeper (tick, bucket);

    final Dingbat[] dingbats = new Dingbat[nDingbats];
    for (int i = 0; i < dingbats.length; i++) {
      dingbats[i] = new Dingbat (i + minDingbat, bucket);
    }

    new Parallel (
      new CSProcess[] {
        bucketKeeper,
        new Parallel (dingbats)
      }
    ).run ();

  }

}
