import jcsp.lang.*;
import jcsp.util.*;
import jcsp.util.ints.*;
import jcsp.awt.*;

import java.awt.*;
import java.awt.event.*;

public class Bounce implements CSProcess {

  private final Image[] images;
  private final Color background;

  private final Panel panel;

  private final ActiveCanvas activeCanvas;
  private final ActiveScrollbar activeScrollBar;

  private final BounceController bounceController;
  private final ImageAnimator imageAnimator;

  public Bounce (Image[] images, Color background, final Container parent, final int nSiblings) {

    this.images = images;
    this.background = background;

    // channels ...

    final One2OneChannel mouseEvent = One2OneChannel.create (new OverWriteOldestBuffer (10));
    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();
    final One2OneChannelInt control = new One2OneChannelInt ();
    final One2OneChannelInt scroll = One2OneChannelInt.create (new OverWriteOldestBufferInt (1));

    final DisplayList displayList = new DisplayList ();

    // awt processes ...

    activeCanvas = new ActiveCanvas ();
    activeCanvas.addMouseEventChannel (mouseEvent);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setPaintable (displayList);
    activeCanvas.setBackground (background);
    final Dimension parentSize = parent.getSize ();
    activeCanvas.setSize (parentSize.width, parentSize.height/nSiblings);

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.
    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    final int MAX_SCALE = 200;
    final int SLIDER = 30;
    activeScrollBar = new ActiveScrollbar (
      null, scroll, Scrollbar.VERTICAL,
      MAX_SCALE, SLIDER, 0, MAX_SCALE + SLIDER
    );

    panel = new Panel ();
    panel.setLayout (new BorderLayout ());
    panel.add ("West", activeScrollBar);
    panel.add ("Center", activeCanvas);

    // application-specific processes ...

    bounceController = new BounceController (
      mouseEvent, scroll, control, MAX_SCALE
    );

    imageAnimator = new ImageAnimator (
      control, toGraphics, fromGraphics, displayList, images, 1, 1
    );

  }

  public Panel getPanel () {
    return panel;
  }


  public void run () {

    new Parallel (
      new CSProcess[] {
        activeScrollBar,
        activeCanvas,
        bounceController,
        imageAnimator
      }
    ).run ();

  }

}
