import jcsp.lang.*;
import jcsp.awt.*;

import java.util.*;
import java.awt.*;

public class BallsControl0 implements CSProcess {

  private final ChannelOutput[] toBalls;
  private final DisplayList displayList;
  private final ChannelOutput toGraphics;
  private final ChannelInput fromGraphics;

  public BallsControl0 (final ChannelOutput[] toBalls,
                        final DisplayList displayList,
                        final ChannelOutput toGraphics,
                        final ChannelInput fromGraphics) {
    this.toBalls = toBalls;
    this.displayList = displayList;
    this.toGraphics = toGraphics;
    this.fromGraphics = fromGraphics;
  }

  private final static class Graphic implements GraphicsCommand.Graphic {
    public Color colour;
    public int x, y, width, height;
    public void doGraphic (java.awt.Graphics g, java.awt.Component c) {
      c.setBackground (colour);
      g.clearRect (x, y, width, height);
    }
  }

  Graphic oldGraphic = new Graphic ();
  Graphic newGraphic = new Graphic ();

  GraphicsCommand oldCommand = new GraphicsCommand.General (oldGraphic);
  GraphicsCommand newCommand = new GraphicsCommand.General (newGraphic);

  public void run() {

    toGraphics.write (GraphicsProtocol.GET_DIMENSION);
    final Dimension graphicsDim = (Dimension) fromGraphics.read ();
    System.out.println ("BallsControl: graphics dimension = " + graphicsDim);

    final CSTimer tim = new CSTimer ();
    final long seed = tim.read ();
    final Random random = new Random (seed + toBalls.length);

    // initialise data for background colour ...

    newGraphic.colour = new Color (random.nextInt ());
    newGraphic.width = graphicsDim.width;
    newGraphic.height = graphicsDim.height;
    newGraphic.x = 0;
    newGraphic.y = 0;

    oldGraphic.width = newGraphic.width;
    oldGraphic.height = newGraphic.height;
    oldGraphic.x = 0;
    oldGraphic.y = 0;

    displayList.set (newCommand);

    for (int i = 0; i < toBalls.length; i++) {
      toBalls[i].write (graphicsDim);
      toBalls[i].write (new Long (seed));
    }

    final Thread me = Thread.currentThread ();
    me.setPriority (Thread.MAX_PRIORITY);

    final long second = 1000;  // JCSP Timer units are milliseconds
    long interval = second/5;

    long timeout;                         // timeouts will drift ... but never mind ...
    // long timeout = tim.read ();        // timeouts won't drift ... not wanted here ...

    while (true) {

        timeout = tim.read () + interval;   // timeouts will drift ... but never mind ...
        // timeout += interval;             // timeouts won't drift ... not wanted here ...

        final Graphic tmpA = oldGraphic;
        oldGraphic = newGraphic;
        newGraphic = tmpA;

        final GraphicsCommand tmpB = oldCommand;
        oldCommand = newCommand;
        newCommand = tmpB;

        newGraphic.colour = new Color (random.nextInt ());

        tim.after (timeout);

        displayList.change (newCommand, 0);

     }

  }

}
