import jcsp.lang.*;

public class StressedWriterInt implements CSProcess {

  private final ChannelOutputInt out;
  private final int channel;
  private final int writer;
  private final int nWritersPerChannel;
  private final String id;

  public StressedWriterInt (ChannelOutputInt out, int channel, int writer,
                            final int nWritersPerChannel) {
    this.out = out;
    this.channel = channel;
    this.writer = writer;
    this.nWritersPerChannel = nWritersPerChannel;
    this.id = "channel " + channel + " writer " + writer;
  }

  public void run () {
    int n = writer;
    while (true) {
      // for (int i = 0; i < writer; i++) System.out.print ("  ");
      // System.out.println (id + " " + (n / nWritersPerChannel));
      out.write (n);
      n += nWritersPerChannel;
    }
  }

}
