import jcsp.lang.*;

public class CanteenInt implements CSProcess {

  private final AltingChannelInputInt supply;    // from the cook
  private final AltingChannelInputInt request;   // from a philosopher
  private final ChannelOutputInt deliver;        // to a philosopher

  public CanteenInt (final AltingChannelInputInt supply,
                     final AltingChannelInputInt request, final ChannelOutputInt deliver) {
    this.supply = supply;
    this.request = request;
    this.deliver = deliver;
  }

  public void run() {

    final Guard[] guard = {supply, request};
    final boolean[] preCondition = new boolean[guard.length];
    final int SUPPLY = 0;
    final int REQUEST = 1;

    final Alternative alt = new Alternative (guard);

    final int maxChickens = 20;
    final int maxSupply = 4;
    final int limitChickens = maxChickens - maxSupply;

    final int oneChicken = 1;   // for consumption!

    int nChickens = 0;

    while (true) {
      preCondition[SUPPLY] = (nChickens <= limitChickens);
      preCondition[REQUEST] = (nChickens > 0);
      switch (alt.priSelect (preCondition)) {
        case SUPPLY:
          nChickens += supply.read ();
        break;
        case REQUEST:
          int dummy = request.read ();  // we have to still input the signal
          deliver.write (oneChicken);
          nChickens--;
        break;
      }
    }

  }

}
