import jcsp.lang.*;

public class Variate implements CSProcess {

  private final ChannelOutput out;
  private final int start, stop, n;

  public Variate (final ChannelOutput out, final int start,
                  final int stop, final int n) {
    this.out = out;
    this.start = start;
    this.stop = stop;
    this.n = n;
  }

  public void run () {

    final int innerCycleTime = n*start;

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read ();

    while (true) {
      int interval = start;
      while (interval >= stop) {
        final Integer Interval = new Integer (interval);
        final int innerCycles = innerCycleTime/interval;
        for (int i = 0; i < innerCycles; i++) {
          out.write (Interval);
          timeout += (long) interval;
          tim.after (timeout);
        }
        interval /= 2;
      }
    }

  }

}
