import jcsp.lang.*;
import jcsp.plugNplay.Printer;

class RegulateTest {

  public static void main (String[] args) {

    final One2OneChannel a = new One2OneChannel ();
    final One2OneChannel b = new One2OneChannel ();
    final One2OneChannel reset = new One2OneChannel ();

    new Parallel (
      new CSProcess[] {
        new Variate (a, 5000, 10, 2),
        new Regulate (a, reset, b, 500),
        new Printer (b, "RegulateTest ==> ", "\n"),
        new CSProcess () {
          // this controls the Regulate process, switching its firing
          // rate between a half and one second.  The switches occur
          // every five seconds.
          public void run () {
            final Long halfSecond = new Long (500);
            final Long second = new Long (1000);
            final CSTimer tim = new CSTimer ();
            long timeout = tim.read ();
            while (true) {
              timeout += 5000;
              tim.after (timeout);
              System.out.println ("                    <== now every second");
              reset.write (second);
              timeout += 5000;
              tim.after (timeout);
              System.out.println ("                    <== now every half second");
              reset.write (halfSecond);
            }
          }
        }
      }
    ).run ();

  }

}
