package tool;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestListener;
//import org.jcsp.lang.*;
import jcsp.lang.*;

import java.lang.*;
import java.util.*;
import javax.swing.JOptionPane;

import newjcircusutil.multisync.GeneralChannel;

public abstract class JCSPTestCase extends TestCase {
/*****ABAIXO O CDIGO DA CLASSE TESTER**********/	

	Tester tester;
	public CSProcess preparedProcess;
	Synchronizer synch;
	Timer _timer_;
	int timeToWait = 1;
	boolean afePointer = false;
	
	ProcessManager p_tester, p_synch, p_timer, p_tested;
	
	int timeCounter;
	
	public abstract void contentOfTest ();
	public abstract void contentOfSynchronization ();
	public abstract void setUp ();
	
	public void sleep (int seconds) {
		try {
			Thread.sleep (seconds * 1000);
		}
		catch (InterruptedException ie) {
			System.out.println ("EXCEO: No foi possvel o processo dormir");
		}
	}
	private void prepareSynchronizationAndTimer (int timerseconds) {
		_timer_ = new Timer (timerseconds);
		synch = new Synchronizer ();
		p_synch = new ProcessManager (synch);
		p_timer = new ProcessManager (_timer_);
	}
	private void prepareSynchronizationAndTimer () {
		prepareSynchronizationAndTimer (1);
	}
	public void prepareProcess (CSProcess csp) {
		prepareSynchronizationAndTimer ();
		tester = new Tester (csp);
		p_tested = new ProcessManager (csp/*preparedProcess*/);
		p_tester = new ProcessManager (tester);
	}
	public void setTimer (int seconds) {
		prepareSynchronizationAndTimer (seconds);
	}

	public void applyTest () {
		tester.applyTest (preparedProcess, _timer_, synch);
	}

	public void testprocess () {
		applyTest();
		if (afePointer) {
			throw new AssertionFailedError ("Sequence of events refused");
		}
	}
	
	public class Synchronizer extends Thread implements CSProcess {
		public void run () {
			contentOfSynchronization ();
		}
	}
	public class Timer extends Thread implements CSProcess {
		String jopt;
		int time;
		public Timer (int seconds) {
			this.time = time;
		}
		public void run () {
			time = timeToWait;
			p_synch.start();
			p_tested.start();
			try {
				Thread.sleep (time * 1000);
			} 
			catch (InterruptedException ie) {JOptionPane.showMessageDialog (null, "Interrupted Exception");}
			if (ProcessInterceptor.aspectOf().getContentOfSynchExecuted()) {
				JOptionPane.showMessageDialog (null, "Synchronization ok for " + time + " seconds");
			}
			else {
				JOptionPane.showMessageDialog (null, "Synchronization NOT ok for " + time + " seconds. The sequence of events was refused. The test will be killed");
				p_synch.stop();
				p_tested.stop();
				afePointer = true;
			}
		}
	}
	public class Tester extends Thread implements CSProcess {
		public Tester (CSProcess cspr) {
			preparedProcess = cspr;
		}
		public void run () {
			contentOfTest();
		}
		public void applyTest (CSProcess tested, CSProcess timer, CSProcess synch) {
			//ProcessManager p_tested = new ProcessManager (tested);
			(new Parallel (new CSProcess [] {/*p_tested,*/ p_timer,/* p_synch,*/ p_tester})).run();
		}
	}

/************ACIMA O CDIGO DA CLASSE TESTER*************************/

/***** ABAIXO O CDIGO DOS MTODOS DE TESTES DE TRACES E REFUSAL******/

	public void assertTraceProceeds (TestingTrace t, Event [] rel) {
		int i;
		for (i = 0; i < rel.length; i++) {
			t.addToRelevance (rel[i]);
		}
		t.buildHighlightedSet();
		if (t.isSubsequence()) {}
		else throw new AssertionFailedError();
	}
	public void assertTraceDoesntProceed (TestingTrace t, Event [] rel) {
		int i;
		for (i = 0; i < rel.length; i++) {
			t.addToRelevance (rel[i]);
		}
		t.buildHighlightedSet();
		if (t.isSubsequence()) {
			throw new AssertionFailedError();
		}		
	}
	
	public boolean matches (Event a, Event b) {
		if (a.getChannel() == b.getChannel()
			&& a.getObject().equals(b.getObject())
			&& a.getAccesstype() != b.getAccesstype()) {
			JOptionPane.showMessageDialog (null, "MATCHES!");
			return true;
		}
		else {
			//CDIGO A SER REMOVIDO DEPOIS
			/*if (a.getChannel() != b.getChannel ()) {
				JOptionPane.showMessageDialog (null, "HASHCODES DE CANAIS DIFERENTES");
			}
			if (a.getObject() != b.getObject ()) {
				JOptionPane.showMessageDialog (null, "OBJETOS DIFERENTES");
			}*/
			//CDIGO A SER REMOVIDO DEPOIS
			JOptionPane.showMessageDialog (null, "DOESN'T MATCH!");
			return false;
		}
	}
	/*public void assertIsRefused (TestingTrace t, Event a) { //falta ser testada!!!!!!!!!!!!!!
		if (!t.isSubsequence()) {
			JOptionPane.showMessageDialog (null, "NO  SUBSEQUENCIA!");
			throw new AssertionFailedError();
		}
		JOptionPane.showMessageDialog (null, "ndice da trace aceita: " + t.indexOfAcceptedTrace());
		if (matches (ProcessInterceptor.aspectOf().allOperations.elementAt (t.indexOfAcceptedTrace()), a)) {
			JOptionPane.showMessageDialog (null, "METCH!!");			
			throw new AssertionFailedError();
		}
	}
	public void assertIsNotRefused (TestingTrace t, Event a) {
		if (!t.isSubsequence()) {}
		else {
			JOptionPane.showMessageDialog (null, " SUBSEQUENCIA!");
			throw new AssertionFailedError();
		}
		JOptionPane.showMessageDialog (null, "ndice da trace aceita: " + t.indexOfAcceptedTrace());
		if (matches (ProcessInterceptor.aspectOf().allOperations.elementAt (t.indexOfAcceptedTrace()), a)) {}
		else {
			JOptionPane.showMessageDialog (null, "NO METCH!!");
			throw new AssertionFailedError();
		}		
	}*/
	/*public void synchronize () {
		ChannelOutput channelOut;
		ChannelInput channelIn;
		Object writtenObj, readObj;
		int desiredIndex, hashChannel;

		desiredIndex = ProcessInterceptor.aspectOf().indexOfLast - 1;
		if (desiredIndex > -1 && desiredIndex < ProcessInterceptor.aspectOf().allOperations.size())
			hashChannel = ProcessInterceptor.aspectOf().allOperations.elementAt(desiredIndex).getChannel();
		
		channelOut = (ChannelOutput)ProcessInterceptor.aspectOf().mapchannel.get(hashChannel);
		channelIn = (ChannelInput)ProcessInterceptor.aspectOf().mapchannel.get(hashChannel);
		
		writtenObj = ProcessInterceptor.aspectOf().allOperations.elementAt(desiredIndex).getObject();
		
		while (ProcessInterceptor.aspectOf().auxChan != 0) {
			if (desiredIndex >= 0 && ProcessInterceptor.aspectOf().allOperations.elementAt(
					desiredIndex).getAccesstype() == Action.READING 
					) {
				channelOut.write(writtenObj);
			}
			else {
				readObj = channelIn.read();
			}
		}
	}*/
	
/***** ACIMA O CDIGO DOS MTODOS DE TESTES DE TRACES E REFUSAL******/
	
	
	public void assertWasSyncOnGeneralChannel (GeneralChannel gc) { //NEWWWWWW
		if (ProcessInterceptor.aspectOf().containsSync (gc.hashCode(), Event.SYNC)) {
		}
		else throw new AssertionFailedError ();
		
	}
	
	public void assertWasWrittenOnChannel (Any2OneChannel chan, Object o) {
		Vector <Event> vec = ProcessInterceptor.aspectOf().allOperations;
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.WRITING, o)) {
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasWrittenOnChannel (One2OneChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.WRITING, o)) {
			//JOptionPane.showMessageDialog (null,"***************ESCREVEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasWrittenOnChannel (One2AnyChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.WRITING, o)) {
			//JOptionPane.showMessageDialog (null,"***************ESCREVEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasWrittenOnChannel (Any2AnyChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.WRITING, o)) {
			//JOptionPane.showMessageDialog (null,"***************ESCREVEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasWrittenOnChannel (ChannelOutput chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.WRITING, o)) {
			//JOptionPane.showMessageDialog (null,"***************ESCREVEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
//falta testar o mtodo abaixo	
	public void assertWasWrittenOnChannel (ChannelOutputInt chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.WRITING, o)) {
			//JOptionPane.showMessageDialog (null,"***************ESCREVEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (Any2OneChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
			//JOptionPane.showMessageDialog (null,"***************LEU!!!***********");
		}
		else {
			throw new AssertionFailedError ();
		}
	}
	public void assertWasReadOnChannel (One2OneChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
			//JOptionPane.showMessageDialog (null,"***************LEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (One2AnyChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
			//JOptionPane.showMessageDialog (null,"***************LEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (Any2AnyChannel chan, Object o) {
		//sleep (1);
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
			//JOptionPane.showMessageDialog (null,"***************LEU!!!***********");
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (ChannelOutput chan, Object o) {
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (ChannelOutputInt chan, Object o) {
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (AltingChannelInput chan, Object o) {
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
		}
		else throw new AssertionFailedError ();
	}
	public void assertWasReadOnChannel (ChannelInput chan, Object o) {
		if (ProcessInterceptor.aspectOf().containsOperation (chan.hashCode(), Event.READING, o)) {
		}
		else throw new AssertionFailedError ();
	}
	
	public void assertThereWasSynchronizationOnChannel (Any2OneChannel chan, Object o) {
		assertWasReadOnChannel (chan, o);
		assertWasWrittenOnChannel (chan, o);
		//JOptionPane.showMessageDialog (null,"***************PORTANTO, SINCRONIZOU***********");
	}
	public void assertThereWasSynchronizationOnChannel (Any2AnyChannel chan, Object o) {
		assertWasReadOnChannel (chan, o);
		assertWasWrittenOnChannel (chan, o);
	}
	public void assertThereWasSynchronizationOnChannel (One2AnyChannel chan, Object o) {
		assertWasReadOnChannel (chan, o);
		assertWasWrittenOnChannel (chan, o);
	}
	public void assertThereWasSynchronizationOnChannel (One2OneChannel chan, Object o) {
		assertWasReadOnChannel (chan, o);
		assertWasWrittenOnChannel (chan, o);
	}
	
	public void assertRunning (CSProcess csp) {
		//sleep (1);
		if (((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get(csp.hashCode()))
				.getProcessState() != ProcessIdent.PROCESS_RUNNING) {
			throw new AssertionFailedError();
		}
		else {
//			JOptionPane.showMessageDialog (null,"Processo rodando");			
		}
	}
	
	public void assertDidntRunYet (CSProcess csp) {
		//sleep (1);
		if (((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get(csp.hashCode()))
				.getProcessState() != ProcessIdent.PROCESS_NOT_RAN_YET)
			throw new AssertionFailedError();
		else {/*JOptionPane.showMessageDialog (null,"Processo est com o estado PROCESS_NOT_RAN_YET");*/}
	}
	
	public void assertHasAlreadyRan (CSProcess csp) {
		//sleep (1);
		if (((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get(csp.hashCode()))
				.getProcessState() != ProcessIdent.PROCESS_ALREADY_RAN) {
			throw new AssertionFailedError();
		}
		else {/*JOptionPane.showMessageDialog (null,"Processo est com o estado PROCESS_ALREADY_RAN");*/}
	}

	public void assertNotRunning (CSProcess csp) {
		//sleep (1);
		if (((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get(csp.hashCode()))
				.getProcessState() == ProcessIdent.PROCESS_RUNNING) {
			throw new AssertionFailedError();
		}
		else {
			JOptionPane.showMessageDialog (null,"Processo rodando");			
		}
	}
//Falta testar os mtodos abaixo	
	public void assertRunningInParallel (CSProcess [] csparray) {
		int aux = 0;
		//sleep (1);
		for (int i = 0; i < csparray.length; i++) {
			if ((((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get((csparray[i]).hashCode()))
					.getProcessState() == ProcessIdent.PROCESS_NOT_RAN_YET)
				||
				(((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get((csparray[i]).hashCode()))
						.getProcessState() == ProcessIdent.PROCESS_ALREADY_RAN)
				) {
				aux++;
			}
		}
		if (aux != 0) {
			throw new AssertionFailedError();			
		}
		else {
			//JOptionPane.showMessageDialog (null,"Processos verificados esto rodando em paralelo");
		}
	}
	
	public void assertNotRunningInParallel (CSProcess [] csparray) {
		int aux = 0;
		//sleep (1);
		for (int i = 0; i < csparray.length; i++) {
			if ((((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get((csparray[i]).hashCode()))
					.getProcessState() == ProcessIdent.PROCESS_NOT_RAN_YET)
				||
				(((ProcessIdent)ProcessInterceptor.aspectOf().mapproc.get((csparray[i]).hashCode()))
						.getProcessState() == ProcessIdent.PROCESS_ALREADY_RAN)
				) {
				aux++;
			}
		}
		if (aux == 0) {
			throw new AssertionFailedError();
		}
	}
	
	public void tearDown() throws Exception {
		super.tearDown();
	}
}
