package fireControlSystem.util;

import java.util.Locale;
import java.util.ResourceBundle;

/*
 * Class responsible for the configuration of the system
 *
 * Created on 23 May 2003, 15:58
 * @author  Marcel Oliveira
 */
public class Config{

    private static Config config;
    private ResourceBundle configs;

    private Config() {
        this.configs = ResourceBundle.getBundle("config");
        //this.configs = ResourceBundle.getBundle("config\\config.properties");
    }
    public static Config getInstance(){
        if(config == null){
            config = new Config();
        }
        return config;
    }
    public String getMessage(String code) {
        String config = configs.getString(code);
        return config;
    }
}
