package fireControlSystem.util;

/*
 * Provides some auxiliar methods used in the system
 *
 * Created on 15 May 2003, 18:51
 * @author  Marcel Oliveira
 */
public class AuxiliarMethods {
    
    /*
     * Verifies if the given number belongin the given array
     *
     * @param int number The number to be verified
     * @param int[] intArray The array in which the number should exist
     */
    public static boolean exists(int number, int[] intArray){
        boolean exists = false;
        for(int i=0; i<intArray.length-1 && !exists; i++){
            if (intArray[i]==number){
                exists = true;
            }
        }
        return exists;
    }
    
    /* 
     * Flips a given integer
     * @param Integer i - The integer to be flipped
     * @return Integer - The flipped i
     */
    public static Integer flip(Integer i) {
        return new Integer(-(i.intValue()+1));
    }
    
}
