package fireControlSystem.typing;

/*
 * Represents an object of a circus free type
 *
 * Created on 12 May 2003, 10:55
 * @author  Marcel Oliveira
 */
public abstract class Type {
    
    /*
     * Current value of this object
     */
    private int value;

    public static final int AREA_ID     = 0;
    public static final int ZONE_ID     = 1;
    public static final int LAMP_ID     = 2;
    public static final int FAULT_ID    = 3;
    public static final int ON_OFF      = 4;
    public static final int MODE        = 5;
    public static final int SWITCH_MODE = 6;
    public static final int ALARM_STAGE = 7;
    
    public static final int MIN_TYPE_ID = 0;
    public static final int MAX_TYPE_ID = 7;

    public int getValue() {
        return this.value;
    }
    protected void setValue(int value) {
        this.value = value;
    }
    /*
     * Compares another object with this one
     */
    public boolean equals(Type otherValue) {
        boolean equals = false;
        if (otherValue != null) {
            boolean sameClass = this.getClass().equals(otherValue.getClass());
            boolean sameValue = (this.getValue()==otherValue.getValue());
            equals = (sameClass && sameValue);
        }
        return equals;
    }
    
    public int compareTo(Type other){
        int compare = -1;
        if (other != null) {
            if (this.getValue() == other.getValue()){
                compare = 0;
            } else if (this.getValue() > other.getValue()) {
                compare = 1;
            }
        }
        return compare;
    }
    
    /* Returns the string representation of this object */
    public String toString() {
        return this.getValue() + "";
    }
}
