package fireControlSystem.typing;

import java.util.Vector;

/*
 * Represents a set of a given FreeType
 *
 * Created on 21 May 2003, 20:57
 * @author  Marcel Oliveira
 */
public class SetOfType {

    private Vector elements;
    
    /* Creates a new instance of SetOfFreeType */
    public SetOfType() {
        this.elements = new Vector();
    }
    
    /* Adds an element to the set */
    public void addElement(Type newElement) {
        if (!this.contains(newElement)) {
            elements.add(newElement);
        }
    }

    /* Adds an element to the set */
    public Type getElement(int index) {
       return (Type)elements.elementAt(index);
    }

    /* Verifies if a given element is in the set */
    public boolean contains(Type element) {
        boolean contains = false;
        for (int i =0; i < elements.size() && !contains; i++) {
            if (((Type)elements.elementAt(i)).equals(element)) {
                contains = true;
            }
        }
        return contains;
    }
    
    /* Verifies if a given set of free type is a subset of this set */
    public boolean contains(SetOfType subset) {
        boolean contains = true;
        for (int i =0; i < subset.size(); i++) {
            if (!this.contains(subset.getElement(i))) {
                contains = false;
            }
        }
        return contains;
    }

    /* Returns the size of the set */
    public int size() {
        return elements.size();
    }

    public String toString() {
        String str = "{ ";
        for (int i=0; i<this.elements.size(); i++) {
            str = str + this.elements.elementAt(i) + " ";
        }
        str = str + "}";
        return str;
    }
}
