package fireControlSystem.typing;

/*
 * Represents the modes of the system
 *
 * Created on 16 May 2003, 10:51
 * @author  Marcel Oliveira
 */
public class Mode extends Type {
    
    /* Ids of existent modes */
    public static final int AUTOMATIC = 0;
    public static final int MANUAL    = 1;
    public static final int DISABLED  = 2;
    
    /* Limits of the modes */
    public static final int MIN_MODE = 0;
    public static final int MAX_MODE = 2;

    /*
     * Creates a new instance of Mode with the respective value 
     */
    protected Mode(){
    }
    
    /*
     * Creates a new instance of Mode with the respective value 
     * @param value The value of the object Mode
     */
    public Mode(int value) {
        this.setValue(value);
    }
}
