package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Classe que representa o processo SimpleLamps
 *
 * Created on 13 May 2003, 12:36
 * @author  Marcel Oliveira
 */
public class SimpleLamps implements CSProcess {

    private ChannelInput[][] switchLamp;
    
    /* Creates a new instance of FireLamps */
    public SimpleLamps(ChannelInput[][] newswitchLamp) {
        this.switchLamp = newswitchLamp; 
    }
    
    /* runs this process */
    public void run() {
        (new CSProcess(){
            public void run(){
                Vector procVec_0 = new Vector();
                class I_0 implements CSProcess {
                    private LampId id;

                    public I_0 (LampId newid){
                        this.id = newid;
                    }

                    public void run(){
                        (new CSProcess(){
                            public void run(){
                                (new GenericLamp(new Integer(Type.LAMP_ID),id,switchLamp)).run();
                            }
                        }).run();
                    }
                }

                for (LampId id = new LampId(LampId.MIN_LAMP_ID); 
                        id.compareTo(new LampId(LampId.MAX_LAMP_ID)) <= 0; id=new LampId(id.getValue()+1) ) {
                    procVec_0.add(new I_0(id));
                }

                CSProcess[] processes_0 = new CSProcess[procVec_0.size()];

                for (int i=0; i < procVec_0.size(); i++) {
                    processes_0[i] = (CSProcess)procVec_0.get(i);
                }
                (new Parallel(processes_0)).run();
            }
        }).run();
    }
 
}
