package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Controls the multi-synchronisation of multiple processes
 * in a given channel
 *
 * @author  Marcel Oliveira
 * Created on 05 June 2003, 11:45
 */
public class MultiSyncControl implements CSProcess{
    
    /* 
     * ID do multi sync control
     */
    private int id;

    /* 
     * Number of clients wanting to synchronise on the channel
     */
    private int numberOfClients;
    
    /* 
     * Answer from the SyncControl to the clients
     */
    private ChannelOutput[] fromSync;

    /* 
     * Request from a client to synchronise
     */
    private ChannelInput toSync;

    /* 
     * Creates a new instance of SyncControl 
     * @param int numberOfClients - Number of clients wanting to synchronise on the channel
     * @param ChannelOutput[] fromSync - Answer from the SyncControl to the clients
     * @param ChannelInput toSync - Request from a client to synchronise
     */
    /*
    public MultiSyncControl(int id, int numberOfClients, 
                            ChannelOutput[] fromSync, ChannelInput toSync) {
        this.id = id;                    
        this.numberOfClients = numberOfClients;
        this.fromSync = fromSync;
        this.toSync = toSync;
    }
     */
    public MultiSyncControl(ChannelOutput[] fromSync, ChannelInput toSync) {
        this.id = 0;                    
        this.numberOfClients = fromSync.length;
        this.fromSync = fromSync;
        this.toSync = toSync;
    }
    
    /* 
     * Runs this process
     */
    public void run() {
        this.offer(this.numberOfClients);
    }

    /* 
     * Receives offers to synchronise from the clients
     * @param int countDown - Number of clients still to send the offer
     */
    private void offer(int countdown) {
        if (countdown > 0  && countdown <= this.numberOfClients) {
            Integer x = (Integer)toSync.read();
            int nextOffer = x.intValue();
            if (nextOffer >= 0) {
                this.offer(countdown-1);
            } else if (nextOffer < 0){
                int flipNextOffer = (AuxiliarMethods.flip(new Integer(nextOffer))).intValue();
                this.fromSync[flipNextOffer].write(new Boolean(false));
                this.offer(countdown+1);
            }
        } else if (countdown == 0) {
            this.invite(0);
        }
    }
    
    /* 
     * Invites the clients to commit
     * @param int client - The client to invite
     */
    private void invite(int client) {
        if (client < numberOfClients) {
            this.fromSync[client].write(new Boolean(true));
            this.invite(client+1);
        } else if (client == numberOfClients) {
            this.invitePrime(0,this.numberOfClients);
        }
    }

    /* 
     * Accepts commitments from the clients
     * @param int client - Next client to receive the commitment
     * @param int coutndown - Number of clients still to send the commitment
     */
    private void invitePrime(int client, int countdown) {
        if (client >= 0 && client < this.numberOfClients) {
            int nextCommit = ((Integer)this.toSync.read()).intValue();
            if (nextCommit >= 0) {
                this.invitePrime(client+1,countdown-1);
            } else if (nextCommit < 0) {
                this.invitePrime(client+1,countdown);
            }
        } else if (client == this.numberOfClients) {
            this.sync(0,countdown);
        }
    }
    
    /* 
     * Try to synchronise with the clients
     * @param int client - Next client to synchronise
     * @param int coutndown - Number of clients still to synchronise
     */
    private void sync(int client, int countdown) {
        if (client < numberOfClients) {
            this.fromSync[client].write(new Boolean(countdown==0));
            if (countdown==0) {
                Object value = this.toSync.read();
                this.syncV(client+1,countdown,value);
            } else if (countdown!=0) {
            }
            this.sync(client+1,countdown);
        } else if (client == numberOfClients) {
            this.syncPrime(countdown);
        }
    }

    /* 
     * Transmite the received value to the clients
     * @param int client - Next client to synchronise
     * @param int coutndown - Number of clients still to synchronise
     * @param Object value - The value to be transmited
     */
    private void syncV(int client, int countdown, Object value) {
        if (client < numberOfClients) {
            this.fromSync[client].write(new Boolean(countdown==0));
            this.fromSync[client].write(value);
            this.syncV(client+1,countdown,value);
        } else if (client == numberOfClients) {
            this.syncPrime(countdown);
        }
    }

    /* 
     * Restarts the SyncControl
     * @param int coutndown - Number of clients still to synchronise
     */
    private void syncPrime(int countdown) {
        if (countdown > 0) {
            this.offer(countdown);
        } else if (countdown == 0) {
            this.offer(this.numberOfClients);
        }
    }

}

